/*
 * Decompiled with CFR 0.152.
 */
package Hack.Controller;

import Hack.Controller.Breakpoint;
import Hack.Controller.Command;
import Hack.Controller.ControllerException;
import Hack.Controller.ScriptCondition;
import Hack.Controller.ScriptException;
import Hack.Controller.ScriptTokenizer;
import Hack.Controller.VariableFormat;
import Hack.Utilities.Conversions;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class Script {
    public static final int MAX_SIMULATOR_COMMAND_ARGUMENTS = 4;
    public static final int MAX_OUTPUT_LIST_ARGUMENTS = 20;
    private Vector commands;
    private Vector lineNumbers;
    private String scriptName;
    private ScriptTokenizer input;

    public Script(String string) throws ScriptException, ControllerException {
        this.scriptName = string;
        try {
            this.input = new ScriptTokenizer(new FileReader(string));
        }
        catch (IOException iOException) {
            throw new ScriptException("Script " + string + " not found");
        }
        this.commands = new Vector();
        this.lineNumbers = new Vector();
        this.buildScript();
    }

    private void buildScript() throws ScriptException, ControllerException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Command command = null;
        int n = 0;
        while (this.input.hasMoreTokens()) {
            n = this.input.getLineNumber() - 1;
            this.input.advance();
            if (bl3 && this.input.getTokenType() == 2 && this.input.getSymbol() == '}') {
                this.scriptError("An empty " + (bl ? "Repeat" : "While") + " block is not allowed");
            }
            bl3 = false;
            switch (this.input.getTokenType()) {
                case 1: {
                    command = this.createControllerCommand();
                    if (command.getCode() == 8) {
                        if (bl || bl2) {
                            this.scriptError("Nested Repeat and While are not allowed");
                            break;
                        }
                        bl = true;
                        bl3 = true;
                        break;
                    }
                    if (command.getCode() == 10) {
                        if (bl || bl2) {
                            this.scriptError("Nested Repeat and While are not allowed");
                            break;
                        }
                        bl2 = true;
                        bl3 = true;
                        break;
                    }
                    if (command.getCode() == 4) {
                        bl4 = true;
                        break;
                    }
                    if (command.getCode() != 5 || bl4) break;
                    this.scriptError("No output list created");
                    break;
                }
                case 3: {
                    command = this.createSimulatorCommand();
                    break;
                }
                case 4: {
                    this.scriptError("A command cannot begin with " + this.input.getIntValue());
                }
                case 2: {
                    if (this.input.getSymbol() == '}') {
                        if (!bl && !bl2) {
                            this.scriptError("a '}' without a Repeat or While");
                            break;
                        }
                        if (bl) {
                            command = new Command(9);
                            bl = false;
                            break;
                        }
                        if (!bl2) break;
                        command = new Command(11);
                        bl2 = false;
                        break;
                    }
                    this.scriptError("A command cannot begin with '" + this.input.getSymbol() + "'");
                }
            }
            switch (this.input.getSymbol()) {
                case ',': {
                    command.setTerminator((byte)1);
                    break;
                }
                case ';': {
                    command.setTerminator((byte)2);
                    break;
                }
                case '!': {
                    command.setTerminator((byte)3);
                }
            }
            this.commands.addElement(command);
            this.lineNumbers.addElement(new Integer(n));
        }
        if (bl || bl2) {
            this.scriptError("Repeat or While not closed");
        }
        command = new Command(12);
        this.commands.addElement(command);
        this.lineNumbers.addElement(new Integer(n));
    }

    private Command createSimulatorCommand() throws ControllerException, ScriptException {
        int n;
        String[] stringArray = this.readArgs(4);
        for (n = 0; n < stringArray.length && stringArray[n] != null; ++n) {
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return new Command(1, stringArray2);
    }

    private Command createControllerCommand() throws ControllerException, ScriptException {
        Command command = null;
        switch (this.input.getKeywordType()) {
            case 1: {
                command = this.createOutputFileCommand();
                break;
            }
            case 2: {
                command = this.createCompareToCommand();
                break;
            }
            case 3: {
                command = this.createOutputListCommand();
                break;
            }
            case 4: {
                command = this.createOutputCommand();
                break;
            }
            case 9: {
                command = this.createEchoCommand();
                break;
            }
            case 10: {
                command = this.createClearEchoCommand();
                break;
            }
            case 5: {
                command = this.createBreakpointCommand();
                break;
            }
            case 6: {
                command = this.createClearBreakpointsCommand();
                break;
            }
            case 7: {
                command = this.createRepeatCommand();
                break;
            }
            case 8: {
                command = this.createWhileCommand();
            }
        }
        return command;
    }

    private Command createOutputFileCommand() throws ControllerException, ScriptException {
        this.input.advance();
        String[] stringArray = this.readArgs(1);
        return new Command(2, stringArray[0]);
    }

    private Command createCompareToCommand() throws ControllerException, ScriptException {
        this.input.advance();
        String[] stringArray = this.readArgs(1);
        return new Command(3, stringArray[0]);
    }

    private Command createOutputListCommand() throws ControllerException, ScriptException {
        int n;
        this.input.advance();
        String[] stringArray = this.readArgs(20);
        for (n = 0; n < stringArray.length && stringArray[n] != null; ++n) {
        }
        VariableFormat[] variableFormatArray = new VariableFormat[n];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(37);
            if (n2 == -1) {
                n2 = stringArray[i].length();
                int n3 = i;
                stringArray[n3] = stringArray[n3] + "%B1.1.1";
            }
            String string = stringArray[i].substring(0, n2);
            char c = stringArray[i].charAt(n2 + 1);
            if (c != 'B' && c != 'D' && c != 'X' && c != 'S') {
                this.scriptError("%" + c + " is not a legal format");
            }
            int n4 = 0;
            int n5 = stringArray[i].indexOf(46, n2);
            if (n5 == -1) {
                this.scriptError("Missing '.'");
            }
            try {
                n4 = Integer.parseInt(stringArray[i].substring(n2 + 2, n5));
            }
            catch (NumberFormatException numberFormatException) {
                this.scriptError("padL must be a number");
            }
            if (n4 < 0) {
                this.scriptError("padL must be positive");
            }
            int n6 = 0;
            int n7 = stringArray[i].indexOf(46, n5 + 1);
            if (n7 == -1) {
                this.scriptError("Missing '.'");
            }
            try {
                n6 = Integer.parseInt(stringArray[i].substring(n5 + 1, n7));
            }
            catch (NumberFormatException numberFormatException) {
                this.scriptError("len must be a number");
            }
            if (n6 < 1) {
                this.scriptError("len must be greater than 0");
            }
            int n8 = 0;
            try {
                n8 = Integer.parseInt(stringArray[i].substring(n7 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                this.scriptError("padR must be a number");
            }
            if (n8 < 0) {
                this.scriptError("padR must be positive");
            }
            variableFormatArray[i] = new VariableFormat(string, c, n4, n8, n6);
        }
        return new Command(4, variableFormatArray);
    }

    private Command createOutputCommand() throws ControllerException, ScriptException {
        this.input.advance();
        this.checkTerminator();
        return new Command(5);
    }

    private Command createEchoCommand() throws ControllerException, ScriptException {
        this.input.advance();
        String[] stringArray = this.readArgs(1);
        return new Command(13, stringArray[0]);
    }

    private Command createClearEchoCommand() throws ControllerException, ScriptException {
        this.input.advance();
        this.checkTerminator();
        return new Command(14);
    }

    private Command createBreakpointCommand() throws ControllerException, ScriptException {
        String string;
        int n;
        this.input.advance();
        String[] stringArray = this.readArgs(2);
        for (n = 0; n < stringArray.length && stringArray[n] != null; ++n) {
        }
        if (n < 2) {
            this.scriptError("Not enough arguments");
        }
        if ((string = stringArray[1]).startsWith("%S")) {
            string = string.substring(2);
        } else if (stringArray[1].startsWith("%")) {
            string = Conversions.toDecimalForm(string);
        }
        Breakpoint breakpoint = new Breakpoint(stringArray[0], string);
        return new Command(6, breakpoint);
    }

    private Command createClearBreakpointsCommand() throws ControllerException, ScriptException {
        this.input.advance();
        this.checkTerminator();
        return new Command(7);
    }

    private Command createRepeatCommand() throws ScriptException, ControllerException {
        this.input.advance();
        int n = 0;
        if (this.input.getTokenType() == 4) {
            n = this.input.getIntValue();
            if (n < 1) {
                this.scriptError("Illegal repeat quantity");
            }
            this.input.advance();
        }
        if (this.input.getTokenType() != 2 || this.input.getSymbol() != '{') {
            this.scriptError("Missing '{' in repeat command");
        }
        return new Command(8, new Integer(n));
    }

    private Command createWhileCommand() throws ScriptException, ControllerException {
        this.input.advance();
        ScriptCondition scriptCondition = null;
        try {
            scriptCondition = new ScriptCondition(this.input);
        }
        catch (ScriptException scriptException) {
            this.scriptError(scriptException.getMessage());
        }
        if (this.input.getTokenType() != 2 || this.input.getSymbol() != '{') {
            this.scriptError("Missing '{' in while command");
        }
        return new Command(10, scriptCondition);
    }

    private String[] readArgs(int n) throws ControllerException, ScriptException {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (this.input.hasMoreTokens() && this.input.getTokenType() != 2 && n2 < n) {
            stringArray[n2++] = this.input.getToken();
            this.input.advance();
        }
        this.checkTerminator();
        if (n2 == 0) {
            this.scriptError("Missing arguments");
        }
        return stringArray;
    }

    private void checkTerminator() throws ScriptException {
        if (this.input.getTokenType() != 2) {
            if (this.input.hasMoreTokens()) {
                this.scriptError("too many arguments");
            } else {
                this.scriptError("Script ends without a terminator");
            }
        } else if (this.input.getSymbol() != ',' && this.input.getSymbol() != ';' && this.input.getSymbol() != '!') {
            this.scriptError("Illegal terminator: '" + this.input.getSymbol() + "'");
        }
    }

    private void scriptError(String string) throws ScriptException {
        throw new ScriptException(string, this.scriptName, this.input.getLineNumber());
    }

    public Command getCommandAt(int n) {
        return (Command)this.commands.elementAt(n);
    }

    public int getLineNumberAt(int n) {
        return (Integer)this.lineNumbers.elementAt(n);
    }

    public int getLength() {
        return this.commands.size();
    }
}

