/*
 * Decompiled with CFR 0.152.
 */
package AssemblerGUI;

import AssemblerGUI.ASMFileFilter;
import AssemblerGUI.HACKFileFilter;
import Hack.Assembler.HackAssemblerGUI;
import Hack.ComputerParts.TextFileGUI;
import HackGUI.MouseOverJButton;
import HackGUI.TextFileComponent;
import TranslatorsGUI.TranslatorComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class AssemblerComponent
extends TranslatorComponent
implements HackAssemblerGUI {
    private ImageIcon equalIcon;
    private MouseOverJButton compareButton;
    private JMenuItem loadCompareMenuItem;
    private JLabel equalLabel;
    private TextFileComponent comparison;
    protected JFileChooser compareFileChooser;

    public AssemblerComponent() {
        super((FileFilter)new ASMFileFilter(), (FileFilter)new HACKFileFilter());
        this.comparison.disableUserInput();
        this.comparison.setName("Comparison");
        this.compareFileChooser = new JFileChooser();
        this.compareFileChooser.setFileFilter(this.destFilter);
    }

    public void setWorkingDir(File file) {
        super.setWorkingDir(file);
        this.compareFileChooser.setCurrentDirectory(file);
    }

    public void disableLoadComparison() {
        this.compareButton.setEnabled(false);
        this.loadCompareMenuItem.setEnabled(false);
    }

    public void enableLoadComparison() {
        this.compareButton.setEnabled(true);
        this.loadCompareMenuItem.setEnabled(true);
    }

    public void setComparisonName(String string) {
        this.compareFileChooser.setName(string);
        this.compareFileChooser.setSelectedFile(new File(string));
    }

    public void showComparison() {
        this.comparison.setVisible(true);
        this.equalLabel.setVisible(true);
    }

    public void hideComparison() {
        this.comparison.setVisible(false);
        this.equalLabel.setVisible(false);
    }

    public TextFileGUI getComparison() {
        return this.comparison;
    }

    protected void arrangeMenu() {
        super.arrangeMenu();
        this.fileMenu.removeAll();
        this.fileMenu.add(this.loadSourceMenuItem);
        this.loadCompareMenuItem = new JMenuItem("Load Comparison File", 67);
        this.loadCompareMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssemblerComponent.this.loadCompareMenuItem_actionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveDestMenuItem);
        this.fileMenu.add(this.loadCompareMenuItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMenuItem);
    }

    protected void init() {
        super.init();
        this.equalIcon = new ImageIcon("bin/images/equal.gif");
        this.equalLabel = new JLabel();
        this.comparison = new TextFileComponent();
        this.compareButton = new MouseOverJButton();
    }

    private void loadComparison() {
        int n = this.compareFileChooser.showDialog((Component)((Object)this), "Load Comparison File");
        if (n == 0) {
            this.notifyHackTranslatorListeners((byte)9, this.compareFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    protected void arrangeToolBar() {
        super.arrangeToolBar();
        this.toolBar.addSeparator(separatorDimension);
        this.toolBar.add((Component)this.compareButton);
    }

    protected void jbInit() {
        super.jbInit();
        this.equalLabel.setBounds(new Rectangle(632, 324, 88, 71));
        this.equalLabel.setIcon(this.equalIcon);
        this.equalLabel.setVisible(false);
        this.comparison.setVisibleRows(31);
        this.comparison.setVisible(false);
        this.comparison.setBounds(new Rectangle(725, 100, this.comparison.getWidth(), this.comparison.getHeight()));
        this.compareButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AssemblerComponent.this.loadCompareButton_actionPerformed(actionEvent);
            }
        });
        this.compareButton.setMaximumSize(new Dimension(39, 39));
        this.compareButton.setMinimumSize(new Dimension(39, 39));
        this.compareButton.setPreferredSize(new Dimension(39, 39));
        this.compareButton.setSize(new Dimension(39, 39));
        this.compareButton.setToolTipText("Load Comparison File");
        this.compareButton.setIcon((Icon)new ImageIcon("bin/images/smallequal.gif"));
        this.getContentPane().add((Component)this.equalLabel, null);
        this.getContentPane().add((Component)this.comparison, null);
    }

    public void loadCompareMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.loadComparison();
    }

    public void loadCompareButton_actionPerformed(ActionEvent actionEvent) {
        this.loadComparison();
    }
}

