/*
 * Decompiled with CFR 0.152.
 */
package Hack.VirtualMachine;

import java.util.Hashtable;

public class HVMInstructionSet {
    public static final byte ADD_CODE = 1;
    public static final byte SUBSTRACT_CODE = 2;
    public static final byte NEGATE_CODE = 3;
    public static final byte EQUAL_CODE = 4;
    public static final byte GREATER_THAN_CODE = 5;
    public static final byte LESS_THAN_CODE = 6;
    public static final byte AND_CODE = 7;
    public static final byte OR_CODE = 8;
    public static final byte NOT_CODE = 9;
    public static final byte PUSH_CODE = 10;
    public static final byte POP_CODE = 11;
    public static final byte LABEL_CODE = 12;
    public static final byte GOTO_CODE = 13;
    public static final byte IF_GOTO_CODE = 14;
    public static final byte FUNCTION_CODE = 15;
    public static final byte RETURN_CODE = 16;
    public static final byte CALL_CODE = 17;
    public static final byte UNKNOWN_INSTRUCTION = -99;
    public static final String ADD_STRING = "add";
    public static final String SUBSTRACT_STRING = "sub";
    public static final String NEGATE_STRING = "neg";
    public static final String EQUAL_STRING = "eq";
    public static final String GREATER_THAN_STRING = "gt";
    public static final String LESS_THAN_STRING = "lt";
    public static final String AND_STRING = "and";
    public static final String OR_STRING = "or";
    public static final String NOT_STRING = "not";
    public static final String PUSH_STRING = "push";
    public static final String POP_STRING = "pop";
    public static final String LABEL_STRING = "label";
    public static final String GOTO_STRING = "goto";
    public static final String IF_GOTO_STRING = "if-goto";
    public static final String FUNCTION_STRING = "function";
    public static final String RETURN_STRING = "return";
    public static final String CALL_STRING = "call";
    public static final int NUMBER_OF_ACTUAL_SEGMENTS = 5;
    public static final byte LOCAL_SEGMENT_CODE = 0;
    public static final byte ARG_SEGMENT_CODE = 1;
    public static final byte THIS_SEGMENT_CODE = 2;
    public static final byte THAT_SEGMENT_CODE = 3;
    public static final byte TEMP_SEGMENT_CODE = 4;
    public static final byte STATIC_SEGMENT_CODE = 100;
    public static final byte CONST_SEGMENT_CODE = 101;
    public static final byte POINTER_SEGMENT_CODE = 102;
    public static final byte UNKNOWN_SEGMENT = -1;
    public static final String STATIC_SEGMENT_VM_STRING = "static";
    public static final String LOCAL_SEGMENT_VM_STRING = "local";
    public static final String ARG_SEGMENT_VM_STRING = "argument";
    public static final String THIS_SEGMENT_VM_STRING = "this";
    public static final String THAT_SEGMENT_VM_STRING = "that";
    public static final String TEMP_SEGMENT_VM_STRING = "temp";
    public static final String CONST_SEGMENT_VM_STRING = "constant";
    public static final String POINTER_SEGMENT_VM_STRING = "pointer";
    private static HVMInstructionSet instance;
    private Hashtable instructionToCode;
    private Hashtable instructionToString;
    private Hashtable segmentCodes;
    private Hashtable segmentStrings;
    private Hashtable segmentPointerStrings;

    private HVMInstructionSet() {
        instance = this;
        this.initInstructions();
        this.initSegmentStrings();
        this.initSegmentCodes();
    }

    public static HVMInstructionSet getInstance() {
        if (instance == null) {
            new HVMInstructionSet();
        }
        return instance;
    }

    private void initInstructions() {
        this.instructionToCode = new Hashtable();
        this.instructionToCode.put(ADD_STRING, new Byte(1));
        this.instructionToCode.put(SUBSTRACT_STRING, new Byte(2));
        this.instructionToCode.put(NEGATE_STRING, new Byte(3));
        this.instructionToCode.put(EQUAL_STRING, new Byte(4));
        this.instructionToCode.put(GREATER_THAN_STRING, new Byte(5));
        this.instructionToCode.put(LESS_THAN_STRING, new Byte(6));
        this.instructionToCode.put(AND_STRING, new Byte(7));
        this.instructionToCode.put(OR_STRING, new Byte(8));
        this.instructionToCode.put(NOT_STRING, new Byte(9));
        this.instructionToCode.put(PUSH_STRING, new Byte(10));
        this.instructionToCode.put(POP_STRING, new Byte(11));
        this.instructionToCode.put(LABEL_STRING, new Byte(12));
        this.instructionToCode.put(GOTO_STRING, new Byte(13));
        this.instructionToCode.put(IF_GOTO_STRING, new Byte(14));
        this.instructionToCode.put(FUNCTION_STRING, new Byte(15));
        this.instructionToCode.put(RETURN_STRING, new Byte(16));
        this.instructionToCode.put(CALL_STRING, new Byte(17));
        this.instructionToString = new Hashtable();
        this.instructionToString.put(new Byte(1), ADD_STRING);
        this.instructionToString.put(new Byte(2), SUBSTRACT_STRING);
        this.instructionToString.put(new Byte(3), NEGATE_STRING);
        this.instructionToString.put(new Byte(4), EQUAL_STRING);
        this.instructionToString.put(new Byte(5), GREATER_THAN_STRING);
        this.instructionToString.put(new Byte(6), LESS_THAN_STRING);
        this.instructionToString.put(new Byte(7), AND_STRING);
        this.instructionToString.put(new Byte(8), OR_STRING);
        this.instructionToString.put(new Byte(9), NOT_STRING);
        this.instructionToString.put(new Byte(10), PUSH_STRING);
        this.instructionToString.put(new Byte(11), POP_STRING);
        this.instructionToString.put(new Byte(12), LABEL_STRING);
        this.instructionToString.put(new Byte(13), GOTO_STRING);
        this.instructionToString.put(new Byte(14), IF_GOTO_STRING);
        this.instructionToString.put(new Byte(15), FUNCTION_STRING);
        this.instructionToString.put(new Byte(16), RETURN_STRING);
        this.instructionToString.put(new Byte(17), CALL_STRING);
    }

    private void initSegmentStrings() {
        this.segmentPointerStrings = new Hashtable();
        this.segmentPointerStrings.put(LOCAL_SEGMENT_VM_STRING, "LCL");
        this.segmentPointerStrings.put(ARG_SEGMENT_VM_STRING, "ARG");
        this.segmentPointerStrings.put(THIS_SEGMENT_VM_STRING, "THIS");
        this.segmentPointerStrings.put(THAT_SEGMENT_VM_STRING, "THAT");
        this.segmentStrings = new Hashtable();
        this.segmentStrings.put(new Byte(100), STATIC_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(0), LOCAL_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(1), ARG_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(2), THIS_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(3), THAT_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(4), TEMP_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(101), CONST_SEGMENT_VM_STRING);
        this.segmentStrings.put(new Byte(102), POINTER_SEGMENT_VM_STRING);
    }

    private void initSegmentCodes() {
        this.segmentCodes = new Hashtable();
        this.segmentCodes.put(STATIC_SEGMENT_VM_STRING, new Byte(100));
        this.segmentCodes.put(LOCAL_SEGMENT_VM_STRING, new Byte(0));
        this.segmentCodes.put(ARG_SEGMENT_VM_STRING, new Byte(1));
        this.segmentCodes.put(THIS_SEGMENT_VM_STRING, new Byte(2));
        this.segmentCodes.put(THAT_SEGMENT_VM_STRING, new Byte(3));
        this.segmentCodes.put(TEMP_SEGMENT_VM_STRING, new Byte(4));
        this.segmentCodes.put(CONST_SEGMENT_VM_STRING, new Byte(101));
        this.segmentCodes.put(POINTER_SEGMENT_VM_STRING, new Byte(102));
    }

    public byte instructionStringToCode(String string) {
        Byte by = (Byte)this.instructionToCode.get(string);
        return by != null ? (byte)by : (byte)-99;
    }

    public String instructionCodeToString(byte by) {
        return (String)this.instructionToString.get(new Byte(by));
    }

    public boolean isLegalVMSegment(String string) {
        return this.segmentCodes.get(string) != null;
    }

    public byte segmentVMStringToCode(String string) {
        Byte by = (Byte)this.segmentCodes.get(string);
        return by != null ? (byte)by : (byte)-1;
    }

    public String segmentStringVMToPointer(String string) {
        return (String)this.segmentPointerStrings.get(string);
    }

    public String segmentCodeToVMString(byte by) {
        return (String)this.segmentStrings.get(new Byte(by));
    }
}

