/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.PointedMemorySegmentGUI;
import HackGUI.MemorySegmentComponent;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.event.FocusEvent;
import javax.swing.table.DefaultTableCellRenderer;

public class PointedMemorySegmentComponent
extends MemorySegmentComponent
implements PointedMemorySegmentGUI {
    protected short pointerAddress = (short)-1;
    protected boolean hasFocus = false;

    public void setStartAddress(int n) {
        super.setStartAddress(n);
        this.scrollToPointer();
    }

    public void setPointer(int n) {
        this.pointerAddress = (short)n;
        this.scrollToPointer();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new PointedMemorySegmentTableCellRenderer();
    }

    protected void scrollToPointer() {
        if (this.pointerAddress >= 0) {
            Utilities.tableCenterScroll(this, this.segmentTable, this.pointerAddress);
        }
    }

    public void segmentTable_focusGained(FocusEvent focusEvent) {
        super.segmentTable_focusGained(focusEvent);
        this.hasFocus = true;
    }

    public void segmentTable_focusLost(FocusEvent focusEvent) {
        super.segmentTable_focusLost(focusEvent);
        this.hasFocus = false;
    }

    public class PointedMemorySegmentTableCellRenderer
    extends MemorySegmentComponent.MemorySegmentTableCellRenderer {
        public void setRenderer(int n, int n2) {
            if (n == PointedMemorySegmentComponent.this.pointerAddress - PointedMemorySegmentComponent.this.startAddress) {
                this.setBackground(Color.yellow);
            } else {
                this.setBackground(null);
            }
            super.setRenderer(n, n2);
        }
    }
}

