/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.MemoryGUI;
import Hack.Events.ClearEvent;
import Hack.Events.ClearEventListener;
import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import HackGUI.Format;
import HackGUI.MemoryChangeListener;
import HackGUI.MouseOverJButton;
import HackGUI.SearchMemoryWindow;
import HackGUI.TranslationException;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MemoryComponent
extends JPanel
implements MemoryGUI {
    protected static final int DEFAULT_VISIBLE_ROWS = 10;
    public int dataFormat = 0;
    private Vector listeners;
    private Vector clearListeners;
    private Vector errorEventListeners;
    private Vector changeListeners;
    protected JTable memoryTable;
    private MemoryTableModel tableModel = new MemoryTableModel();
    protected String[] valuesStr;
    protected short[] values;
    protected String[] addresses;
    protected MouseOverJButton searchButton = new MouseOverJButton();
    protected MouseOverJButton clearButton = new MouseOverJButton();
    private ImageIcon searchIcon = new ImageIcon("bin/images/find.gif");
    private ImageIcon clearIcon = new ImageIcon("bin/images/smallnew.gif");
    private SearchMemoryWindow searchWindow;
    protected JScrollPane scrollPane;
    protected Vector highlightIndex;
    protected int flashIndex = -1;
    protected Point topLevelLocation;
    protected JLabel nameLbl = new JLabel();
    protected boolean isEnabled = true;
    protected short nullValue;
    protected boolean hideNullValue;
    protected int startEnabling = -1;
    protected int endEnabling = -1;
    protected boolean grayDisabledRange;

    public MemoryComponent() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(Utilities.bigBoldValueFont);
        jTextField.setBorder(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        this.listeners = new Vector();
        this.clearListeners = new Vector();
        this.errorEventListeners = new Vector();
        this.changeListeners = new Vector();
        this.highlightIndex = new Vector();
        this.memoryTable = new JTable(this.getTableModel());
        this.memoryTable.setDefaultRenderer(this.memoryTable.getColumnClass(0), this.getCellRenderer());
        this.memoryTable.getColumnModel().getColumn(this.getValueColumnIndex()).setCellEditor(defaultCellEditor);
        this.memoryTable.setTableHeader(null);
        this.values = new short[0];
        this.addresses = new String[0];
        this.valuesStr = new String[0];
        this.searchWindow = new SearchMemoryWindow(this, this.memoryTable);
        this.jbInit();
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
    }

    public void enableUserInput() {
        this.isEnabled = true;
    }

    public void disableUserInput() {
        this.isEnabled = false;
    }

    protected int getValueColumnIndex() {
        return 1;
    }

    protected TableModel getTableModel() {
        return new MemoryTableModel();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new MemoryTableCellRenderer();
    }

    public void setName(String string) {
        this.nameLbl.setText(string);
    }

    public void setTopLevelLocation(Component component) {
        this.topLevelLocation = Utilities.getTopLevelLocation(component, this.memoryTable);
    }

    public void addListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.addElement(computerPartEventListener);
    }

    public void removeListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.removeElement(computerPartEventListener);
    }

    public void notifyListeners(int n, short s) {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this, n, s);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).valueChanged(computerPartEvent);
        }
    }

    public void notifyListeners() {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).guiGainedFocus();
        }
    }

    public void addClearListener(ClearEventListener clearEventListener) {
        this.clearListeners.addElement(clearEventListener);
    }

    public void removeClearListener(ClearEventListener clearEventListener) {
        this.clearListeners.removeElement(clearEventListener);
    }

    public void notifyClearListeners() {
        ClearEvent clearEvent = new ClearEvent((Object)this);
        for (int i = 0; i < this.clearListeners.size(); ++i) {
            ((ClearEventListener)this.clearListeners.elementAt(i)).clearRequested(clearEvent);
        }
    }

    public void addErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.addElement(errorEventListener);
    }

    public void removeErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.removeElement(errorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ErrorEvent errorEvent = new ErrorEvent((Object)this, string);
        for (int i = 0; i < this.errorEventListeners.size(); ++i) {
            ((ErrorEventListener)this.errorEventListeners.elementAt(i)).errorOccured(errorEvent);
        }
    }

    public void addChangeListener(MemoryChangeListener memoryChangeListener) {
        this.changeListeners.addElement(memoryChangeListener);
    }

    public void removeChangeListener(MemoryChangeListener memoryChangeListener) {
        this.changeListeners.removeElement(memoryChangeListener);
    }

    public void notifyRepaintListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((MemoryChangeListener)this.changeListeners.elementAt(i)).repaintChange();
        }
    }

    public void notifyRevalidateListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            ((MemoryChangeListener)this.changeListeners.elementAt(i)).revalidateChange();
        }
    }

    public void setContents(short[] sArray) {
        this.values = new short[sArray.length];
        this.addresses = new String[sArray.length];
        this.valuesStr = new String[sArray.length];
        System.arraycopy(sArray, 0, this.values, 0, sArray.length);
        for (int i = 0; i < this.values.length; ++i) {
            this.addresses[i] = Format.translateValueToString((short)i, 0);
            this.valuesStr[i] = this.translateValueToString(this.values[i]);
        }
        this.memoryTable.revalidate();
        this.repaint();
        this.notifyRevalidateListeners();
    }

    protected void updateTable(short s, int n) {
        this.values[n] = s;
        this.valuesStr[n] = this.translateValueToString(s);
    }

    public void setValueAt(int n, short s) {
        this.updateTable(s, n);
        this.repaint();
        this.notifyRepaintListeners();
    }

    public void reset() {
        for (int i = 0; i < this.values.length; ++i) {
            this.updateTable(this.nullValue, i);
        }
        this.repaint();
        this.notifyRepaintListeners();
        this.memoryTable.clearSelection();
        this.hideFlash();
        this.hideHighlight();
    }

    public void hideHighlight() {
        this.highlightIndex.removeAllElements();
        this.repaint();
    }

    public void highlight(int n) {
        this.highlightIndex.addElement(new Integer(n));
        this.repaint();
    }

    public void hideFlash() {
        this.flashIndex = -1;
        this.repaint();
    }

    public void flash(int n) {
        this.flashIndex = n;
        Utilities.tableCenterScroll(this, this.memoryTable, n);
    }

    public void setEnabledRange(int n, int n2, boolean bl) {
        this.startEnabling = n;
        this.endEnabling = n2;
        this.grayDisabledRange = bl;
        this.repaint();
    }

    public int getMemorySize() {
        return this.values != null ? this.values.length : 0;
    }

    public String getValueAsString(int n) {
        return Format.translateValueToString(this.values[n], this.dataFormat);
    }

    public void select(int n, int n2) {
        this.memoryTable.setRowSelectionInterval(n, n2);
        Utilities.tableCenterScroll(this, this.memoryTable, n);
    }

    public void hideSelect() {
        this.memoryTable.clearSelection();
        this.repaint();
    }

    public Point getCoordinates(int n) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Rectangle rectangle = this.memoryTable.getCellRect(n, this.getValueColumnIndex(), true);
        this.memoryTable.scrollRectToVisible(rectangle);
        return new Point((int)(rectangle.getX() + this.topLevelLocation.getX()), (int)(rectangle.getY() + this.topLevelLocation.getY() - (double)jScrollBar.getValue()));
    }

    public String getAddressStr(short s) {
        return this.addresses[s];
    }

    public String getValueStr(short s) {
        return this.valuesStr[s];
    }

    public short getValueAsShort(short s) {
        return this.values[s];
    }

    protected short translateValueToShort(String string) throws TranslationException {
        short s = 0;
        try {
            s = Format.translateValueToShort(string, this.dataFormat);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TranslationException("Illegal value: " + string);
        }
        return s;
    }

    protected String translateValueToString(short s) {
        if (this.hideNullValue) {
            if (s == this.nullValue) {
                return "";
            }
            return Format.translateValueToString(s, this.dataFormat);
        }
        return Format.translateValueToString(s, this.dataFormat);
    }

    public void setTableFont(Font font) {
        this.memoryTable.setFont(font);
    }

    private void jbInit() {
        this.memoryTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MemoryComponent.this.memoryTable_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                MemoryComponent.this.memoryTable_focusLost(focusEvent);
            }
        });
        this.scrollPane = new JScrollPane(this.memoryTable);
        this.setLayout(null);
        this.searchButton.setToolTipText("Search");
        this.searchButton.setIcon(this.searchIcon);
        this.searchButton.setBounds(new Rectangle(159, 2, 31, 25));
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryComponent.this.searchButton_actionPerformed(actionEvent);
            }
        });
        this.memoryTable.setFont(Utilities.valueFont);
        this.nameLbl.setBounds(new Rectangle(3, 5, 70, 23));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.determineColumnWidth();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.scrollPane.setLocation(0, 27);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryComponent.this.clearButton_actionPerformed(actionEvent);
            }
        });
        this.clearButton.setIcon(this.clearIcon);
        this.clearButton.setBounds(new Rectangle(128, 2, 31, 25));
        this.clearButton.setToolTipText("Clear");
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.searchButton, null);
        this.add((Component)this.nameLbl, null);
        this.add((Component)this.clearButton, null);
    }

    public int getTableWidth() {
        return 193;
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.memoryTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    protected void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.memoryTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(30);
                continue;
            }
            tableColumn.setPreferredWidth(100);
        }
    }

    public void scrollTo(int n) {
        Utilities.tableCenterScroll(this, this.memoryTable, n);
    }

    public void memoryTable_focusGained(FocusEvent focusEvent) {
        this.memoryTable.clearSelection();
        this.notifyListeners();
    }

    public void memoryTable_focusLost(FocusEvent focusEvent) {
        this.memoryTable.clearSelection();
    }

    public void searchButton_actionPerformed(ActionEvent actionEvent) {
        this.searchWindow.showWindow();
    }

    public void clearButton_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new Object[]{"Yes", "No", "Cancel"};
        int n = JOptionPane.showOptionDialog(this.getParent(), "Are you sure you want to clear ?", "Warning Message", 1, 2, null, objectArray, objectArray[2]);
        if (n == 0) {
            this.notifyClearListeners();
        }
    }

    public void setNumericFormat(int n) {
        this.dataFormat = n;
        for (int i = 0; i < this.values.length; ++i) {
            this.valuesStr[i] = this.translateValueToString(this.values[i]);
        }
        this.repaint();
        this.notifyRepaintListeners();
    }

    public void setNameLabelSize() {
        this.nameLbl.setBounds(new Rectangle(3, 7, 150, 23));
    }

    class MemoryTableCellRenderer
    extends DefaultTableCellRenderer {
        MemoryTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(null);
            this.setBackground(null);
            this.setRenderer(n, n2);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setRenderer(int n, int n2) {
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else if (n2 == 1) {
                this.setHorizontalAlignment(4);
                for (int i = 0; i < MemoryComponent.this.highlightIndex.size(); ++i) {
                    if (n != (Integer)MemoryComponent.this.highlightIndex.elementAt(i)) continue;
                    this.setForeground(Color.blue);
                    break;
                }
                if (n == MemoryComponent.this.flashIndex) {
                    this.setBackground(Color.orange);
                }
            }
            if (n < MemoryComponent.this.startEnabling || n > MemoryComponent.this.endEnabling && MemoryComponent.this.grayDisabledRange) {
                this.setForeground(Color.lightGray);
            }
        }
    }

    class MemoryTableModel
    extends AbstractTableModel {
        MemoryTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return MemoryComponent.this.getMemorySize();
        }

        public String getColumnName(int n) {
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return MemoryComponent.this.addresses[n];
            }
            return MemoryComponent.this.valuesStr[n];
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (MemoryComponent.this.isEnabled && n2 == 1 && (MemoryComponent.this.endEnabling == -1 || n >= MemoryComponent.this.startEnabling && n <= MemoryComponent.this.endEnabling)) {
                bl = true;
            }
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = ((String)object).trim();
            if (!MemoryComponent.this.valuesStr[n].equals(string)) {
                try {
                    MemoryComponent.this.valuesStr[n] = string;
                    MemoryComponent.this.values[n] = string.equals("") && MemoryComponent.this.hideNullValue ? MemoryComponent.this.nullValue : MemoryComponent.this.translateValueToShort(string);
                    MemoryComponent.this.notifyListeners((short)n, MemoryComponent.this.values[n]);
                }
                catch (TranslationException translationException) {
                    MemoryComponent.this.notifyErrorListeners(translationException.getMessage());
                    MemoryComponent.this.valuesStr[n] = MemoryComponent.this.translateValueToString(MemoryComponent.this.values[n]);
                }
                MemoryComponent.this.repaint();
                MemoryComponent.this.notifyRepaintListeners();
            }
        }
    }
}

