/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.Controller.ControllerEvent;
import Hack.Controller.ControllerEventListener;
import Hack.Controller.ControllerGUI;
import Hack.Controller.HackSimulatorGUI;
import HackGUI.BreakpointWindow;
import HackGUI.BreakpointsChangedEvent;
import HackGUI.BreakpointsChangedListener;
import HackGUI.FileDisplayComponent;
import HackGUI.FilesTypeEvent;
import HackGUI.FilesTypeListener;
import HackGUI.HTMLViewFrame;
import HackGUI.MouseOverJButton;
import HackGUI.ScriptFileFilter;
import HackGUI.TitledComboBox;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ControllerComponent
extends JFrame
implements ControllerGUI,
FilesTypeListener,
BreakpointsChangedListener {
    protected static final int TOOLBAR_WIDTH = 1016;
    protected static final int TOOLBAR_HEIGHT = 55;
    private static final int CONTROLLER_WIDTH = 1024;
    private static final int CONTROLLER_HEIGHT = 741;
    protected static final Dimension separatorDimension = new Dimension(3, 50);
    private Vector listeners;
    protected MouseOverJButton ffwdButton;
    protected MouseOverJButton stopButton;
    protected MouseOverJButton rewindButton;
    protected MouseOverJButton scriptButton;
    protected MouseOverJButton breakButton;
    protected MouseOverJButton singleStepButton;
    protected MouseOverJButton loadProgramButton;
    private JFileChooser fileChooser = new JFileChooser();
    private BreakpointWindow breakpointWindow = new BreakpointWindow();
    private ImageIcon rewindIcon = new ImageIcon("bin/images/vcrrewind.gif");
    private ImageIcon ffwdIcon = new ImageIcon("bin/images/vcrfastforward.gif");
    private ImageIcon singleStepIcon = new ImageIcon("bin/images/vcrforward.gif");
    private ImageIcon stopIcon = new ImageIcon("bin/images/vcrstop.gif");
    private ImageIcon breakIcon = new ImageIcon("bin/images/redflag.gif");
    private ImageIcon loadProgramIcon = new ImageIcon("bin/images/opendoc.gif");
    private ImageIcon scriptIcon = new ImageIcon("bin/images/scroll.gif");
    protected JSlider speedSlider;
    protected TitledComboBox formatCombo;
    protected TitledComboBox additionalDisplayCombo;
    protected TitledComboBox animationCombo;
    protected JToolBar toolBar;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu viewMenu;
    protected JMenu runMenu;
    protected JMenu helpMenu;
    protected JMenuItem singleStepMenuItem;
    protected JMenuItem ffwdMenuItem;
    protected JMenuItem stopMenuItem;
    protected JMenuItem rewindMenuItem;
    protected JMenuItem exitMenuItem;
    protected JMenuItem usageMenuItem;
    protected JMenuItem aboutMenuItem;
    protected JMenu animationSubMenu;
    protected JMenu numericFormatSubMenu;
    protected JMenu additionalDisplaySubMenu;
    protected JMenuItem breakpointsMenuItem;
    protected JMenuItem scriptMenuItem;
    protected JMenuItem programMenuItem;
    protected JRadioButtonMenuItem decMenuItem;
    protected JRadioButtonMenuItem hexaMenuItem;
    protected JRadioButtonMenuItem binMenuItem;
    protected JRadioButtonMenuItem scriptDisplayMenuItem;
    protected JRadioButtonMenuItem outputMenuItem;
    protected JRadioButtonMenuItem compareMenuItem;
    protected JRadioButtonMenuItem noAdditionalDisplayMenuItem;
    protected JRadioButtonMenuItem partAnimMenuItem;
    protected JRadioButtonMenuItem fullAnimMenuItem;
    protected JRadioButtonMenuItem noAnimMenuItem;
    protected JLabel messageLbl = new JLabel();
    protected FileDisplayComponent scriptComponent;
    protected FileDisplayComponent outputComponent;
    protected FileDisplayComponent comparisonComponent;
    private HTMLViewFrame usageWindow;
    private HTMLViewFrame aboutWindow;

    public ControllerComponent() {
        this.listeners = new Vector();
        this.formatCombo = new TitledComboBox("Format:", "Numeric display format", new String[]{"Decimal", "Hexa", "Binary"}, 75);
        this.additionalDisplayCombo = new TitledComboBox("View:", "View options", new String[]{"Script", "Output", "Compare", "Screen"}, 80);
        this.animationCombo = new TitledComboBox("Animate:", "Animtion type", new String[]{"Program flow", "Program & data flow", "No animation"}, 135);
        this.scriptComponent = new FileDisplayComponent();
        this.outputComponent = new FileDisplayComponent();
        this.comparisonComponent = new FileDisplayComponent();
        this.init();
        this.jbInit();
    }

    public void setWorkingDir(File file) {
        this.fileChooser.setCurrentDirectory(file);
    }

    public void setSimulator(HackSimulatorGUI hackSimulatorGUI) {
        ((JComponent)hackSimulatorGUI).setLocation(0, 55);
        this.getContentPane().add((Component)((JComponent)hackSimulatorGUI), null);
        ((JComponent)hackSimulatorGUI).revalidate();
        this.repaint();
        if (hackSimulatorGUI.getUsageFileName() != null) {
            this.usageWindow = new HTMLViewFrame(hackSimulatorGUI.getUsageFileName());
            this.usageWindow.setSize(450, 430);
        }
        if (hackSimulatorGUI.getAboutFileName() != null) {
            this.aboutWindow = new HTMLViewFrame(hackSimulatorGUI.getAboutFileName());
            this.aboutWindow.setSize(450, 420);
        }
    }

    public JComponent getComparisonComponent() {
        return this.comparisonComponent;
    }

    public JComponent getOutputComponent() {
        return this.outputComponent;
    }

    public JComponent getScriptComponent() {
        return this.scriptComponent;
    }

    protected void init() {
        this.speedSlider = new JSlider(0, 1, 5, 1);
        this.loadProgramButton = new MouseOverJButton();
        this.ffwdButton = new MouseOverJButton();
        this.stopButton = new MouseOverJButton();
        this.rewindButton = new MouseOverJButton();
        this.scriptButton = new MouseOverJButton();
        this.breakButton = new MouseOverJButton();
        this.singleStepButton = new MouseOverJButton();
    }

    public void addControllerListener(ControllerEventListener controllerEventListener) {
        this.listeners.addElement(controllerEventListener);
    }

    public void removeControllerListener(ControllerEventListener controllerEventListener) {
        this.listeners.removeElement(controllerEventListener);
    }

    public void notifyControllerListeners(byte by, Object object) {
        ControllerEvent controllerEvent = new ControllerEvent((Object)this, by, object);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ControllerEventListener)this.listeners.elementAt(i)).actionPerformed(controllerEvent);
        }
    }

    public void setScriptFile(String string) {
        this.scriptComponent.setContents(string);
    }

    public void setOutputFile(String string) {
        this.outputComponent.setContents(string);
    }

    public void setComparisonFile(String string) {
        this.comparisonComponent.setContents(string);
    }

    public void setCurrentScriptLine(int n) {
        this.scriptComponent.setSelectedRow(n);
    }

    public void setCurrentOutputLine(int n) {
        this.outputComponent.setSelectedRow(n);
    }

    public void setCurrentComparisonLine(int n) {
        this.comparisonComponent.setSelectedRow(n);
    }

    public void showBreakpoints() {
        this.breakpointWindow.getTable().clearSelection();
        this.breakpointWindow.setVisible(true);
        if (this.breakpointWindow.getState() == 1) {
            this.breakpointWindow.setState(0);
        }
    }

    public void enableSingleStep() {
        this.singleStepButton.setEnabled(true);
        this.singleStepMenuItem.setEnabled(true);
    }

    public void disableSingleStep() {
        this.singleStepButton.setEnabled(false);
        this.singleStepMenuItem.setEnabled(false);
    }

    public void enableFastForward() {
        this.ffwdButton.setEnabled(true);
        this.ffwdMenuItem.setEnabled(true);
    }

    public void disableFastForward() {
        this.ffwdButton.setEnabled(false);
        this.ffwdMenuItem.setEnabled(false);
    }

    public void enableStop() {
        this.stopButton.setEnabled(true);
        this.stopMenuItem.setEnabled(true);
    }

    public void disableStop() {
        this.stopButton.setEnabled(false);
        this.stopMenuItem.setEnabled(false);
    }

    public void enableScript() {
        this.scriptButton.setEnabled(true);
        this.scriptMenuItem.setEnabled(true);
    }

    public void disableScript() {
        this.scriptButton.setEnabled(false);
        this.scriptMenuItem.setEnabled(false);
    }

    public void enableRewind() {
        this.rewindButton.setEnabled(true);
        this.rewindMenuItem.setEnabled(true);
    }

    public void disableRewind() {
        this.rewindButton.setEnabled(false);
        this.rewindMenuItem.setEnabled(false);
    }

    public void enableLoadProgram() {
        this.loadProgramButton.setEnabled(true);
    }

    public void disableLoadProgram() {
        this.loadProgramButton.setEnabled(false);
    }

    public void disableSpeedSlider() {
        this.speedSlider.setEnabled(false);
    }

    public void enableSpeedSlider() {
        this.speedSlider.setEnabled(true);
    }

    public void disableAnimationModes() {
        this.animationCombo.setEnabled(false);
        this.partAnimMenuItem.setEnabled(false);
        this.fullAnimMenuItem.setEnabled(false);
        this.noAnimMenuItem.setEnabled(false);
    }

    public void enableAnimationModes() {
        this.animationCombo.setEnabled(true);
        this.partAnimMenuItem.setEnabled(true);
        this.fullAnimMenuItem.setEnabled(true);
        this.noAnimMenuItem.setEnabled(true);
    }

    public void setBreakpoints(Vector vector) {
        this.breakpointWindow.setBreakpoints(vector);
    }

    public void setSpeed(int n) {
        this.speedSlider.setValue(n);
        this.repaint();
    }

    public void setVariables(String[] stringArray) {
        this.breakpointWindow.setVariables(stringArray);
    }

    public void filesNamesChanged(FilesTypeEvent filesTypeEvent) {
        if (filesTypeEvent.getFirstFile() != null) {
            this.scriptComponent.setContents(filesTypeEvent.getFirstFile());
            this.notifyControllerListeners((byte)6, filesTypeEvent.getFirstFile());
        }
        if (filesTypeEvent.getSecondFile() != null) {
            this.outputComponent.setContents(filesTypeEvent.getSecondFile());
        }
        if (filesTypeEvent.getThirdFile() != null) {
            this.comparisonComponent.setContents(filesTypeEvent.getThirdFile());
        }
    }

    public void breakpointsChanged(BreakpointsChangedEvent breakpointsChangedEvent) {
        this.notifyControllerListeners((byte)5, breakpointsChangedEvent.getBreakpoints());
    }

    public void outputFileUpdated() {
        this.outputComponent.refresh();
    }

    public void hideController() {
        this.setVisible(false);
    }

    public void showController() {
        this.setVisible(true);
    }

    public void setAnimationMode(int n) {
        if (!this.animationCombo.isSelectedIndex(n)) {
            this.animationCombo.setSelectedIndex(n);
        }
    }

    public void setAdditionalDisplay(int n) {
        if (!this.additionalDisplayCombo.isSelectedIndex(n)) {
            this.additionalDisplayCombo.setSelectedIndex(n);
        }
    }

    public void setNumericFormat(int n) {
        if (!this.formatCombo.isSelectedIndex(n)) {
            this.formatCombo.setSelectedIndex(n);
        }
    }

    public void displayMessage(String string, boolean bl) {
        if (bl) {
            this.messageLbl.setForeground(Color.red);
        } else {
            this.messageLbl.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.messageLbl.setText(string);
        this.messageLbl.setToolTipText(string);
    }

    protected void setControllerSize() {
        this.setSize(new Dimension(1024, 741));
    }

    protected void arrangeToolBar() {
        this.toolBar.add(this.loadProgramButton);
        this.toolBar.addSeparator(separatorDimension);
        this.toolBar.add(this.singleStepButton);
        this.toolBar.add(this.ffwdButton);
        this.toolBar.add(this.stopButton);
        this.toolBar.add(this.rewindButton);
        this.toolBar.addSeparator(separatorDimension);
        this.toolBar.add(this.scriptButton);
        this.toolBar.add(this.breakButton);
        this.toolBar.addSeparator(separatorDimension);
        this.toolBar.add(this.speedSlider);
        this.toolBar.add(this.animationCombo);
        this.toolBar.add(this.additionalDisplayCombo);
        this.toolBar.add(this.formatCombo);
    }

    protected void arrangeMenu() {
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic(86);
        this.menuBar.add(this.viewMenu);
        this.runMenu = new JMenu("Run");
        this.runMenu.setMnemonic(82);
        this.menuBar.add(this.runMenu);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.helpMenu);
        this.programMenuItem = new JMenuItem("Load Program", 79);
        this.programMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.programMenuItem_actionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.programMenuItem);
        this.scriptMenuItem = new JMenuItem("Load Script", 80);
        this.scriptMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.scriptMenuItem_actionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.scriptMenuItem);
        this.fileMenu.addSeparator();
        this.exitMenuItem = new JMenuItem("Exit", 88);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.exitMenuItem_actionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.viewMenu.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.animationSubMenu = new JMenu("Animate");
        this.animationSubMenu.setMnemonic(65);
        this.viewMenu.add(this.animationSubMenu);
        this.partAnimMenuItem = new JRadioButtonMenuItem("Program flow");
        this.partAnimMenuItem.setMnemonic(80);
        this.partAnimMenuItem.setSelected(true);
        this.partAnimMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.partAnimMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup.add(this.partAnimMenuItem);
        this.animationSubMenu.add(this.partAnimMenuItem);
        this.fullAnimMenuItem = new JRadioButtonMenuItem("Program & data flow");
        this.fullAnimMenuItem.setMnemonic(68);
        this.fullAnimMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.fullAnimMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup.add(this.fullAnimMenuItem);
        this.animationSubMenu.add(this.fullAnimMenuItem);
        this.noAnimMenuItem = new JRadioButtonMenuItem("No Animation");
        this.noAnimMenuItem.setMnemonic(78);
        this.noAnimMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.noAnimMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup.add(this.noAnimMenuItem);
        this.animationSubMenu.add(this.noAnimMenuItem);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.additionalDisplaySubMenu = new JMenu("View");
        this.additionalDisplaySubMenu.setMnemonic(86);
        this.viewMenu.add(this.additionalDisplaySubMenu);
        this.scriptDisplayMenuItem = new JRadioButtonMenuItem("Script");
        this.scriptDisplayMenuItem.setMnemonic(83);
        this.scriptDisplayMenuItem.setSelected(true);
        this.scriptDisplayMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.scriptDisplayMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup2.add(this.scriptDisplayMenuItem);
        this.additionalDisplaySubMenu.add(this.scriptDisplayMenuItem);
        this.outputMenuItem = new JRadioButtonMenuItem("Output");
        this.outputMenuItem.setMnemonic(79);
        this.outputMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.outputMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup2.add(this.outputMenuItem);
        this.additionalDisplaySubMenu.add(this.outputMenuItem);
        this.compareMenuItem = new JRadioButtonMenuItem("Compare");
        this.compareMenuItem.setMnemonic(67);
        this.compareMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.compareMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup2.add(this.compareMenuItem);
        this.additionalDisplaySubMenu.add(this.compareMenuItem);
        this.noAdditionalDisplayMenuItem = new JRadioButtonMenuItem("Screen");
        this.noAdditionalDisplayMenuItem.setMnemonic(78);
        this.noAdditionalDisplayMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.noAdditionalDisplayMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup2.add(this.noAdditionalDisplayMenuItem);
        this.additionalDisplaySubMenu.add(this.noAdditionalDisplayMenuItem);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.numericFormatSubMenu = new JMenu("Format");
        this.numericFormatSubMenu.setMnemonic(70);
        this.viewMenu.add(this.numericFormatSubMenu);
        this.decMenuItem = new JRadioButtonMenuItem("Decimal");
        this.decMenuItem.setMnemonic(68);
        this.decMenuItem.setSelected(true);
        this.decMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.decMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup3.add(this.decMenuItem);
        this.numericFormatSubMenu.add(this.decMenuItem);
        this.hexaMenuItem = new JRadioButtonMenuItem("Hexadecimal");
        this.hexaMenuItem.setMnemonic(72);
        this.hexaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.hexaMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup3.add(this.hexaMenuItem);
        this.numericFormatSubMenu.add(this.hexaMenuItem);
        this.binMenuItem = new JRadioButtonMenuItem("Binary");
        this.binMenuItem.setMnemonic(66);
        this.binMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.binMenuItem_actionPerformed(actionEvent);
            }
        });
        buttonGroup3.add(this.binMenuItem);
        this.numericFormatSubMenu.add(this.binMenuItem);
        this.viewMenu.addSeparator();
        this.singleStepMenuItem = new JMenuItem("Single Step", 83);
        this.singleStepMenuItem.setAccelerator(KeyStroke.getKeyStroke("F11"));
        this.singleStepMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.singleStepMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenu.add(this.singleStepMenuItem);
        this.ffwdMenuItem = new JMenuItem("Run", 70);
        this.ffwdMenuItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        this.ffwdMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.ffwdMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenu.add(this.ffwdMenuItem);
        this.stopMenuItem = new JMenuItem("Stop", 84);
        this.stopMenuItem.setAccelerator(KeyStroke.getKeyStroke("shift F5"));
        this.stopMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.stopMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenu.add(this.stopMenuItem);
        this.rewindMenuItem = new JMenuItem("Reset", 82);
        this.rewindMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.rewindMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenu.add(this.rewindMenuItem);
        this.runMenu.addSeparator();
        this.breakpointsMenuItem = new JMenuItem("Breakpoints", 66);
        this.breakpointsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.breakpointsMenuItem_actionPerformed(actionEvent);
            }
        });
        this.runMenu.add(this.breakpointsMenuItem);
        this.usageMenuItem = new JMenuItem("Usage", 85);
        this.usageMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        this.usageMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.usageMenuItem_actionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.usageMenuItem);
        this.aboutMenuItem = new JMenuItem("About ...", 65);
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.aboutMenuItem_actionPerformed(actionEvent);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
    }

    private void scriptPressed() {
        int n = this.fileChooser.showDialog(this, "Load Script");
        if (n == 0) {
            this.notifyControllerListeners((byte)6, this.fileChooser.getSelectedFile().getAbsoluteFile());
            this.scriptComponent.setContents(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void jbInit() {
        this.fileChooser.setFileFilter(new ScriptFileFilter());
        this.getContentPane().setLayout(null);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel("Slow");
        jLabel.setFont(Utilities.thinLabelsFont);
        JLabel jLabel2 = new JLabel("Fast");
        jLabel2.setFont(Utilities.thinLabelsFont);
        hashtable.put(new Integer(1), jLabel);
        hashtable.put(new Integer(5), jLabel2);
        this.speedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ControllerComponent.this.SpeedSlider_stateChanged(changeEvent);
            }
        });
        this.speedSlider.setLabelTable(hashtable);
        this.speedSlider.setMajorTickSpacing(1);
        this.speedSlider.setPaintTicks(true);
        this.speedSlider.setPaintLabels(true);
        this.speedSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.speedSlider.setPreferredSize(new Dimension(95, 50));
        this.speedSlider.setMinimumSize(new Dimension(95, 50));
        this.speedSlider.setToolTipText("Speed");
        this.speedSlider.setMaximumSize(new Dimension(95, 50));
        this.loadProgramButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.loadProgramButton_actionPerformed(actionEvent);
            }
        });
        this.loadProgramButton.setMaximumSize(new Dimension(39, 39));
        this.loadProgramButton.setMinimumSize(new Dimension(39, 39));
        this.loadProgramButton.setPreferredSize(new Dimension(39, 39));
        this.loadProgramButton.setSize(new Dimension(39, 39));
        this.loadProgramButton.setToolTipText("Load Program");
        this.loadProgramButton.setIcon(this.loadProgramIcon);
        this.ffwdButton.setMaximumSize(new Dimension(39, 39));
        this.ffwdButton.setMinimumSize(new Dimension(39, 39));
        this.ffwdButton.setPreferredSize(new Dimension(39, 39));
        this.ffwdButton.setToolTipText("Run");
        this.ffwdButton.setIcon(this.ffwdIcon);
        this.ffwdButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.ffwdButton_actionPerformed(actionEvent);
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.stopButton_actionPerformed(actionEvent);
            }
        });
        this.stopButton.setMaximumSize(new Dimension(39, 39));
        this.stopButton.setMinimumSize(new Dimension(39, 39));
        this.stopButton.setPreferredSize(new Dimension(39, 39));
        this.stopButton.setToolTipText("Stop");
        this.stopButton.setIcon(this.stopIcon);
        this.rewindButton.setMaximumSize(new Dimension(39, 39));
        this.rewindButton.setMinimumSize(new Dimension(39, 39));
        this.rewindButton.setPreferredSize(new Dimension(39, 39));
        this.rewindButton.setToolTipText("Reset");
        this.rewindButton.setIcon(this.rewindIcon);
        this.rewindButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.rewindButton_actionPerformed(actionEvent);
            }
        });
        this.scriptButton.setMaximumSize(new Dimension(39, 39));
        this.scriptButton.setMinimumSize(new Dimension(39, 39));
        this.scriptButton.setPreferredSize(new Dimension(39, 39));
        this.scriptButton.setToolTipText("Load Script");
        this.scriptButton.setIcon(this.scriptIcon);
        this.scriptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.scriptButton_actionPerformed(actionEvent);
            }
        });
        this.breakButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.breakButton_actionPerformed(actionEvent);
            }
        });
        this.breakButton.setMaximumSize(new Dimension(39, 39));
        this.breakButton.setMinimumSize(new Dimension(39, 39));
        this.breakButton.setPreferredSize(new Dimension(39, 39));
        this.breakButton.setToolTipText("Open breakpoint panel");
        this.breakButton.setIcon(this.breakIcon);
        this.breakpointWindow.addBreakpointListener(this);
        this.singleStepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.singleStepButton_actionPerformed(actionEvent);
            }
        });
        this.singleStepButton.setMaximumSize(new Dimension(39, 39));
        this.singleStepButton.setMinimumSize(new Dimension(39, 39));
        this.singleStepButton.setPreferredSize(new Dimension(39, 39));
        this.singleStepButton.setSize(new Dimension(39, 39));
        this.singleStepButton.setToolTipText("Single Step");
        this.singleStepButton.setIcon(this.singleStepIcon);
        this.animationCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.animationCombo_actionPerformed(actionEvent);
            }
        });
        this.formatCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.formatCombo_actionPerformed(actionEvent);
            }
        });
        this.additionalDisplayCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControllerComponent.this.additionalDisplayCombo_actionPerformed(actionEvent);
            }
        });
        this.messageLbl.setFont(Utilities.statusLineFont);
        this.messageLbl.setBorder(BorderFactory.createLoweredBevelBorder());
        this.messageLbl.setBounds(new Rectangle(0, 667, 1016, 25));
        this.toolBar = new JToolBar();
        this.toolBar.setSize(new Dimension(1016, 55));
        this.toolBar.setLayout(new FlowLayout(0, 3, 0));
        this.toolBar.setFloatable(false);
        this.toolBar.setLocation(0, 0);
        this.toolBar.setBorder(BorderFactory.createEtchedBorder());
        this.arrangeToolBar();
        this.getContentPane().add((Component)this.toolBar, null);
        this.toolBar.revalidate();
        this.toolBar.repaint();
        this.repaint();
        this.menuBar = new JMenuBar();
        this.arrangeMenu();
        this.setJMenuBar(this.menuBar);
        this.setDefaultCloseOperation(3);
        this.getContentPane().add((Component)this.messageLbl, null);
        this.setControllerSize();
        this.setVisible(true);
    }

    public void additionalDisplayCombo_actionPerformed(ActionEvent actionEvent) {
        int n = this.additionalDisplayCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                if (this.scriptMenuItem.isSelected()) break;
                this.scriptMenuItem.setSelected(true);
                break;
            }
            case 1: {
                if (this.outputMenuItem.isSelected()) break;
                this.outputMenuItem.setSelected(true);
                break;
            }
            case 2: {
                if (this.compareMenuItem.isSelected()) break;
                this.compareMenuItem.setSelected(true);
                break;
            }
            case 3: {
                if (this.noAdditionalDisplayMenuItem.isSelected()) break;
                this.noAdditionalDisplayMenuItem.setSelected(true);
            }
        }
        this.notifyControllerListeners((byte)12, new Integer(n));
    }

    public void loadProgramButton_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)27, null);
    }

    public void ffwdButton_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)2, null);
    }

    public void rewindButton_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)9, null);
    }

    public void scriptButton_actionPerformed(ActionEvent actionEvent) {
        this.scriptPressed();
    }

    public void breakButton_actionPerformed(ActionEvent actionEvent) {
        this.showBreakpoints();
    }

    public void singleStepButton_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)1, null);
    }

    public void stopButton_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)4, null);
    }

    public void SpeedSlider_stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (!jSlider.getValueIsAdjusting()) {
            int n = jSlider.getValue();
            this.notifyControllerListeners((byte)3, new Integer(n));
        }
    }

    public void animationCombo_actionPerformed(ActionEvent actionEvent) {
        int n = this.animationCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                if (this.partAnimMenuItem.isSelected()) break;
                this.partAnimMenuItem.setSelected(true);
                break;
            }
            case 1: {
                if (this.fullAnimMenuItem.isSelected()) break;
                this.fullAnimMenuItem.setSelected(true);
                break;
            }
            case 2: {
                if (this.noAnimMenuItem.isSelected()) break;
                this.noAnimMenuItem.setSelected(true);
            }
        }
        this.notifyControllerListeners((byte)10, new Integer(n));
    }

    public void formatCombo_actionPerformed(ActionEvent actionEvent) {
        int n = this.formatCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                if (this.decMenuItem.isSelected()) break;
                this.decMenuItem.setSelected(true);
                break;
            }
            case 1: {
                if (this.hexaMenuItem.isSelected()) break;
                this.hexaMenuItem.setSelected(true);
                break;
            }
            case 2: {
                if (this.binMenuItem.isSelected()) break;
                this.binMenuItem.setSelected(true);
            }
        }
        this.notifyControllerListeners((byte)11, new Integer(n));
    }

    public void programMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)27, null);
    }

    public void scriptMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.scriptPressed();
    }

    public void exitMenuItem_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    public void partAnimMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.animationCombo.isSelectedIndex(0)) {
            this.animationCombo.setSelectedIndex(0);
        }
    }

    public void fullAnimMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.animationCombo.isSelectedIndex(1)) {
            this.animationCombo.setSelectedIndex(1);
        }
    }

    public void noAnimMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.animationCombo.isSelectedIndex(2)) {
            this.animationCombo.setSelectedIndex(2);
        }
    }

    public void decMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.formatCombo.isSelectedIndex(0)) {
            this.formatCombo.setSelectedIndex(0);
        }
    }

    public void hexaMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.formatCombo.isSelectedIndex(1)) {
            this.formatCombo.setSelectedIndex(1);
        }
    }

    public void binMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.formatCombo.isSelectedIndex(2)) {
            this.formatCombo.setSelectedIndex(2);
        }
    }

    public void scriptDisplayMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.additionalDisplayCombo.isSelectedIndex(0)) {
            this.additionalDisplayCombo.setSelectedIndex(0);
        }
    }

    public void outputMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.additionalDisplayCombo.isSelectedIndex(1)) {
            this.additionalDisplayCombo.setSelectedIndex(1);
        }
    }

    public void compareMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.additionalDisplayCombo.isSelectedIndex(2)) {
            this.additionalDisplayCombo.setSelectedIndex(2);
        }
    }

    public void noAdditionalDisplayMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (!this.additionalDisplayCombo.isSelectedIndex(3)) {
            this.additionalDisplayCombo.setSelectedIndex(3);
        }
    }

    public void singleStepMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)1, null);
    }

    public void ffwdMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)2, null);
    }

    public void stopMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)4, null);
    }

    public void rewindMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.notifyControllerListeners((byte)9, null);
    }

    public void breakpointsMenuItem_actionPerformed(ActionEvent actionEvent) {
        this.showBreakpoints();
    }

    public void usageMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.usageWindow != null) {
            this.usageWindow.setVisible(true);
        }
    }

    public void aboutMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.aboutWindow != null) {
            this.aboutWindow.setVisible(true);
        }
    }
}

