/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.Controller.Breakpoint;
import HackGUI.BreakpointChangedEvent;
import HackGUI.BreakpointChangedListener;
import HackGUI.Utilities;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class BreakpointVariablesWindow
extends JFrame {
    private JLabel nameLbl = new JLabel();
    private JLabel valueLbl = new JLabel();
    private JTextField nameTxt = new JTextField();
    private JTextField valueTxt = new JTextField();
    private JComboBox nameCombo = new JComboBox();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private ImageIcon okIcon = new ImageIcon("bin/images/ok.gif");
    private ImageIcon cancelIcon = new ImageIcon("bin/images/cancel.gif");
    private Vector listeners = new Vector();
    private Breakpoint breakpoint;

    public BreakpointVariablesWindow() {
        super("Breakpoint Variables");
        this.jbInit();
    }

    public void addListener(BreakpointChangedListener breakpointChangedListener) {
        this.listeners.addElement(breakpointChangedListener);
    }

    public void removeListener(BreakpointChangedListener breakpointChangedListener) {
        this.listeners.removeElement(breakpointChangedListener);
    }

    public void notifyListeners() {
        BreakpointChangedEvent breakpointChangedEvent = new BreakpointChangedEvent(this, this.breakpoint);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((BreakpointChangedListener)this.listeners.elementAt(i)).breakpointChanged(breakpointChangedEvent);
        }
    }

    public void setVariables(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.nameCombo.addItem(stringArray[i]);
        }
    }

    public void setBreakpointName(String string) {
        this.nameTxt.setText(string);
    }

    public void setBreakpointValue(String string) {
        this.valueTxt.setText(string);
    }

    public void setNameCombo(int n) {
        this.nameCombo.setSelectedIndex(n);
    }

    public void showWindow() {
        this.nameTxt.requestFocus();
        this.setVisible(true);
    }

    private void jbInit() {
        this.nameLbl.setFont(Utilities.thinLabelsFont);
        this.nameLbl.setText("Name :");
        this.nameLbl.setBounds(new Rectangle(9, 10, 61, 19));
        this.getContentPane().setLayout(null);
        this.valueLbl.setBounds(new Rectangle(9, 42, 61, 19));
        this.valueLbl.setFont(Utilities.thinLabelsFont);
        this.valueLbl.setText("Value :");
        this.nameTxt.setBounds(new Rectangle(53, 10, 115, 19));
        this.valueTxt.setBounds(new Rectangle(53, 42, 115, 19));
        this.nameCombo.setBounds(new Rectangle(180, 10, 124, 19));
        this.nameCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointVariablesWindow.this.nameCombo_actionPerformed(actionEvent);
            }
        });
        this.okButton.setToolTipText("Ok");
        this.okButton.setIcon(this.okIcon);
        this.okButton.setBounds(new Rectangle(61, 74, 63, 44));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointVariablesWindow.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setBounds(new Rectangle(180, 74, 63, 44));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BreakpointVariablesWindow.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setToolTipText("Cancel");
        this.cancelButton.setIcon(this.cancelIcon);
        this.getContentPane().add((Component)this.nameLbl, null);
        this.getContentPane().add((Component)this.valueLbl, null);
        this.getContentPane().add((Component)this.nameTxt, null);
        this.getContentPane().add((Component)this.valueTxt, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.nameCombo, null);
        this.setSize(320, 160);
        this.setLocation(500, 250);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        this.breakpoint = new Breakpoint(this.nameTxt.getText(), this.valueTxt.getText());
        this.setVisible(false);
        this.notifyListeners();
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void nameCombo_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.nameCombo.getSelectedItem();
        this.nameTxt.setText(string);
    }
}

