//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classes de Aplicao e Interface                                                        //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyright(c):   Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

// for all others, include the necessary headers
#ifndef WX_PRECOMP
#  include "wx/wx.h"
#endif

#include "clprocesso.h"
#include "clfcfs.h"
#include "clSJF.h"
#include "clRJF.h"
#include "clRoundRobin.h"
#include "wx/image.h"
#include "wx/spinctrl.h"

// Define a new application type
class MyApp : public wxApp
{
    public:
        virtual bool OnInit();
};

enum {FILA, RR, SJF, RJF,};

class MyFrame : public wxFrame
{
    public:
        MyFrame();
        ~MyFrame();

        // event handlers for File menu
        void OnSair(wxCommandEvent& event);
        void OnSobre(wxCommandEvent& event);
        void OnConfigurarProcessos(wxCommandEvent& event);
        void OnEscolherPolitica(wxCommandEvent& event);
        void OnTic(wxCommandEvent& event);

        void OnPaint(wxPaintEvent& event);

    private:

        void DesenharFundo(int tipoSimulacao);

        wxMenu *menuArquivo;
        wxMenuBar *barraDeMenu;

        // politicas de escalonamento
        int politicaAtual;
        clRoundRobin *roundRobin;
        clSJF *sjf;
        clFcfs *fila;
        clRJF *rjf;
        deque< clProcesso > *listaProc;
        int tAtual, idAtual, tempoTotal;
        wxImage* tela;
        bool passo_a_passo;

        // medidas do grafico
        int distanciaEntreLinhas;
        int larguraUnidadeTempo;
        int xInicial, yInicial;

    DECLARE_EVENT_TABLE()
};

enum{   ID_SOBRE = 10000, ID_SAIR, ID_TIC, ID_CONF_PROC, ID_ESC_POL,};

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
    EVT_MENU(ID_SAIR, MyFrame::OnSair)
    EVT_MENU(ID_SOBRE, MyFrame::OnSobre)
    EVT_MENU(ID_TIC, MyFrame::OnTic)
    EVT_MENU(ID_CONF_PROC, MyFrame::OnConfigurarProcessos)
    EVT_MENU(ID_ESC_POL, MyFrame::OnEscolherPolitica)
    EVT_PAINT(MyFrame::OnPaint)
END_EVENT_TABLE()

IMPLEMENT_APP(MyApp)

bool MyApp::OnInit()
{
    MyFrame *frame = new MyFrame();
    frame->Show(TRUE);

    return TRUE;
}

MyFrame::MyFrame() : wxFrame((wxFrame *)NULL, -1, "wxEscalProc 1.0", wxPoint(0, 0), wxSize(800, 600))
{
    // Give the frame an icon
    // SetIcon(wxICON(mondrian));

    // Make menus
    menuArquivo = new wxMenu();
    menuArquivo->Append(ID_CONF_PROC, "&Configurar Processos\tF5");
    menuArquivo->Append(ID_ESC_POL, "&Escolher Poltica\tF6");
    menuArquivo->Append(ID_TIC, "&Tic\tF7");
    menuArquivo->Append(ID_SOBRE, "&Sobre");
    menuArquivo->AppendSeparator();
    menuArquivo->Append(ID_SAIR, "Sai&r");

    barraDeMenu = new wxMenuBar();
    barraDeMenu->Append(menuArquivo, "&Arquivo");
    SetMenuBar(barraDeMenu);

    //wxButton *botaoTic = new wxButton(this, ID_TIC, "TIC", wxPoint(400, 550), wxSize(100, 25));
    tAtual = tempoTotal = 0;

    tela = new wxImage(800, 600);

    wxColour cor("WHITE");

    int i;
    //tela->DrawRectangle(0, 0, 800, 600);
    for(i = 0; i < 800; i++)
    {
        for(int j = 0; j < 600; j++)
            tela->SetRGB(i, j, cor.Red(), cor.Green(), cor.Blue());
    }

    distanciaEntreLinhas = 30;
    larguraUnidadeTempo = 30;
    xInicial = 40;
    yInicial = 120;

    roundRobin = NULL;
    sjf = NULL;
    fila = NULL;
    rjf = NULL;
    politicaAtual = -1;
    listaProc = new deque< clProcesso >;
}

MyFrame::~MyFrame()
{
    if(fila)
        delete fila;
    if(rjf)
        delete rjf;
    if(sjf)
        delete sjf;
    if(roundRobin)
        delete roundRobin;
    if(listaProc)
        delete listaProc;
    delete tela;
}

void MyFrame::OnSair(wxCommandEvent& WXUNUSED(event))
{
    Close(TRUE);
}

void MyFrame::OnSobre(wxCommandEvent& WXUNUSED(event))
{
    wxMessageBox("Simultador de Escalonamento de Processos \n\n"
                 "Desenvolvido por (Copyright(c)):\n\n"
                 "Adriano Arlei De Carvalho\n"
                 "Andreia Assuncao Schneider\n"
                 "Anderson De Resende Rocha\n"
                 "Antonio Galvao De Rezendo Filho\n"
                 "Julio Cesar Alves\n\n"
                 "{arlei, andreia, undersun, galvao, jcalves}@comp.ufla.br\n\n"
                 "Disciplina de Redes de Computadores\n"
                 "Cincia da Computao\n"
                 "Universidade Federal de Lavras\n\n"
                 "Lavras, junho de 2003",
                 "Sobre o wxEscalProc",
                wxOK | wxICON_INFORMATION, this);
}

void MyFrame::OnTic(wxCommandEvent& WXUNUSED(event))
{
    if(listaProc->size() > 0)
    {
        wxString str;
        wxColour cor("BLUE");
        deque< clProcesso >::iterator it;

        if(tAtual < tempoTotal)
        {
            do
            {
                switch(politicaAtual)
                {
                    case FILA: idAtual = fila->Tic();       break;
                    case   RR: idAtual = roundRobin->Tic(); break;
                    case  SJF: idAtual = sjf->Tic();        break;
                    case  RJF: idAtual = rjf->Tic();        break;
                }
            }while(idAtual == -1);

            tAtual++;
            for(int i = xInicial+larguraUnidadeTempo*(tAtual-1);
                    i < xInicial+larguraUnidadeTempo*(tAtual-1)+larguraUnidadeTempo; i++)
            {
                for(int j = yInicial+distanciaEntreLinhas*(listaProc->size()-idAtual-1);
                        j < yInicial+distanciaEntreLinhas*(listaProc->size()-idAtual-1)+5; j++)
                    tela->SetRGB(i, j, cor.Red(), cor.Green(), cor.Blue());
            }
            if(passo_a_passo)
                Refresh();
        }
        else if(idAtual != -1)
        {
            // para finalizar
            do
            {
                switch(politicaAtual)
                {
                    case FILA: idAtual = fila->Tic();       break;
                    case   RR: idAtual = roundRobin->Tic(); break;
                    case  SJF: idAtual = sjf->Tic();        break;
                    case  RJF: idAtual = rjf->Tic();        break;
                }
            }while(idAtual == -1);

            if(!passo_a_passo)
                Refresh();

            wxDialog dialogo(this, -1, "Simulao terminada", wxDefaultPosition, wxDefaultSize);

            wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );
            wxGridSizer *item1 = new wxGridSizer( 5, 0, 0 );

            item1->Add( new wxStaticText(&dialogo, -1, "Processo"), 0, wxALIGN_CENTRE|wxALL, 5 );
            item1->Add( new wxStaticText(&dialogo, -1, "Criao"), 0, wxALIGN_CENTRE|wxALL, 5 );
            item1->Add( new wxStaticText(&dialogo, -1, "Processamento"), 0, wxALIGN_CENTRE|wxALL, 5 );
            item1->Add( new wxStaticText(&dialogo, -1, "Finalizao"), 0, wxALIGN_CENTRE|wxALL, 5 );
            item1->Add( new wxStaticText(&dialogo, -1, "Turnaround"), 0, wxALIGN_CENTRE|wxALL, 5 );

            for(it = listaProc->begin(); it != listaProc->end(); it++)
            {
                str = "";
                str << (*it).GetId();
                item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
                str = "";
                str << (*it).GetTCriacao();
                item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
                str = "";
                str << (*it).GetTProcessamento();
                item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
                str = "";
                str << (*it).GetTFinalizacao();
                item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
                str = "";
                str << (*it).GetTurnAround();
                item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
            }

            item1->Add(5, 5, 0, wxALIGN_CENTRE|wxALL, 1); //espacador

            wxButton *btOk = new wxButton(&dialogo, wxID_OK, "Ok");
            item0->Add( item1, 0, wxALL, 5 );

            btOk->SetDefault();
            item0->Add( btOk, 0, wxALIGN_CENTRE|wxALL, 5 );

            dialogo.SetAutoLayout( TRUE );
            dialogo.SetSizer( item0 );
            item0->Fit( &dialogo );
            item0->SetSizeHints( &dialogo );

            dialogo.ShowModal();
        }
    }
}

void MyFrame::OnConfigurarProcessos(wxCommandEvent& WXUNUSED(event))
{
    wxString str("");
    int idProcesso = 0;
    bool terminou = false;
    deque< clProcesso >::iterator it;

    if(listaProc->size() > 0)
    {
        delete listaProc;
        listaProc = new deque< clProcesso >;
    }

    while(!terminou)
    {

        wxDialog dialogo(this, -1, "Processos a serem escalonados", wxDefaultPosition, wxDefaultSize);

        wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );
        wxGridSizer *item1 = new wxGridSizer( 3, 0, 0 );

        wxStaticText *item3 = new wxStaticText(&dialogo, -1, "Processo");
        item1->Add( item3, 0, wxALIGN_CENTRE|wxALL, 5 );

        item1->Add(new wxStaticText(&dialogo, -1, "Tempo de Criao"), 0, wxALIGN_CENTRE|wxALL, 5 );
        item1->Add(new wxStaticText(&dialogo,-1,"Tempo de Processamento"),0, wxALIGN_CENTRE|wxALL, 5 );

        for(it = listaProc->begin(); it != listaProc->end(); it++)
        {
            str = "";
            str << (*it).GetId();
            item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
            str = "";
            str << (*it).GetTCriacao();
            item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
            str = "";
            str << (*it).GetTProcessamento();
            item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
        }

        str = "";
        str << idProcesso;
        item1->Add( new wxStaticText(&dialogo, -1, str), 0, wxALIGN_CENTRE|wxALL, 5 );
        wxSpinCtrl *tempoCriacao = new wxSpinCtrl(&dialogo, -1);
        item1->Add( tempoCriacao, 0, wxALIGN_CENTRE|wxALL, 5 );

        wxSpinCtrl *tempoProc = new wxSpinCtrl(&dialogo, -1);
        item1->Add( tempoProc, 0, wxALIGN_CENTRE|wxALL, 5 );

        item1->Add(5, 5, 0, wxALIGN_CENTRE|wxALL, 1);

        wxButton *botaoAdicionar = new wxButton(&dialogo, wxID_OK, "Adicionar");
        botaoAdicionar->SetDefault();
        item1->Add( botaoAdicionar, 0, wxALIGN_CENTRE|wxALL, 5 );

        wxButton *botaoCancelar = new wxButton(&dialogo, wxID_CANCEL, "Terminado");
        item1->Add( botaoCancelar, 0, wxALIGN_CENTRE|wxALL, 5 );

        item0->Add( item1, 0, wxALL, 5 );

        dialogo.SetAutoLayout( TRUE );
        dialogo.SetSizer( item0 );
        item0->Fit( &dialogo );
        item0->SetSizeHints( &dialogo );

        dialogo.ShowModal();
        if (dialogo.GetReturnCode() == wxID_OK)
        {
            clProcesso p( idProcesso, tempoCriacao->GetValue() , tempoProc->GetValue() );
            listaProc->push_back( p );
            idProcesso++;
        }
        else
		{
			clProcesso p( idProcesso, tempoCriacao->GetValue() , tempoProc->GetValue() );
            listaProc->push_back( p );
            idProcesso++;
            terminou = true;
		}
    }

    wxCommandEvent evento;

    OnEscolherPolitica(evento);
}

void MyFrame::OnEscolherPolitica(wxCommandEvent& WXUNUSED(event))
{
    deque< clProcesso >::iterator it;

    if(listaProc->size() > 0)
    {
        int j = listaProc->size();
        clProcesso processos[j];

        int i = 0;
        for(it = listaProc->begin(); it != listaProc->end(); it++)
        {
            processos[i] = *it;
            i++;
        }

        delete listaProc;
        listaProc = new deque< clProcesso >;

        for(i = 0; i < j; i++)
        {
            clProcesso p(processos[i].GetId(), processos[i].GetTCriacao(), processos[i].GetTProcessamento());
            listaProc->push_back( p );
        }
    }
    else
    {
        wxMessageBox(" necessrio escalonar processos primeiro", "wxEscalProc", wxICON_INFORMATION);
        return;
    }


    wxString politicas[4] = {"Fila","Round Robin","SJF","RJF"};
    wxString tipos[2] = {"Passo a passo","Automtico"};

    // escolhendo poltica de escalonamento e modo de simulao
    wxDialog dialogo(this, -1, "Poltica de escalonamento", wxDefaultPosition, wxDefaultSize);

    wxBoxSizer *item0 = new wxBoxSizer( wxVERTICAL );
    //wxGridSizer *item1 = new wxGridSizer( 3, 0, 0 );

    wxRadioBox *politica = new wxRadioBox(&dialogo, -1, "Escolha a poltica de escalonamento", wxDefaultPosition,
                            wxDefaultSize, 4, politicas);

    item0->Add( politica, 0, wxALIGN_CENTRE|wxALL, 5 );

    wxRadioBox *tipo = new wxRadioBox(&dialogo, -1, "Escolha o modo de Simulao", wxDefaultPosition,
                            wxDefaultSize, 2, tipos);

    item0->Add( tipo, 0, wxALIGN_CENTRE|wxALL, 5 );


    item0->Add(5, 5, 0, wxALIGN_CENTRE|wxALL, 1); //espacador

    wxButton *btOk = new wxButton(&dialogo, wxID_OK, "Ok");

    btOk->SetDefault();
    item0->Add( btOk, 0, wxALIGN_CENTRE|wxALL, 5 );

    dialogo.SetAutoLayout( TRUE );
    dialogo.SetSizer( item0 );
    item0->Fit( &dialogo );
    item0->SetSizeHints( &dialogo );

    dialogo.ShowModal();

    if(fila)
    {
        delete fila;
        fila = NULL;
    }
    if(rjf)
    {
        delete rjf;
        rjf = NULL;
    }
    if(sjf)
    {
        delete sjf;
        sjf = NULL;
    }
    if(roundRobin)
    {
        delete roundRobin;
        roundRobin = NULL;
    }

    int quantum;
    switch(politica->GetSelection())
    {
        case 0:
            fila = new clFcfs(listaProc);
            politicaAtual = FILA;
            break;
        case 1:
            do
            {
                quantum = wxGetNumberFromUser("Digite o quantum", "", "Round Robin", 1, 1);
            } while (quantum == -1);

            roundRobin = new clRoundRobin(listaProc, quantum);
            politicaAtual = RR;
            break;
        case 2:
            sjf = new clSJF(listaProc);
            politicaAtual = SJF;
            break;
        case 3:
            rjf = new clRJF(listaProc);
            politicaAtual = RJF;
            break;
        default: break;
    }
    DesenharFundo(tipo->GetSelection());
}

void MyFrame::DesenharFundo(int tipoSimulacao)
{
    deque< clProcesso >::iterator it;

	xInicial = 40;
    larguraUnidadeTempo = 30;
    distanciaEntreLinhas = 30;

    tempoTotal = 0;

    for(it = listaProc->begin(); it != listaProc->end(); it++)
        tempoTotal+=(*it).GetTProcessamento();

    tAtual = 0;

    if(xInicial+tempoTotal*larguraUnidadeTempo > 800)
        larguraUnidadeTempo = (800-xInicial)/tempoTotal;
	else
		xInicial = (800 - tempoTotal*larguraUnidadeTempo)/2;

    if(yInicial+listaProc->size()*distanciaEntreLinhas > 600)
        distanciaEntreLinhas = (600-yInicial)/listaProc->size();

    wxColour cor("WHITE");


    // desenhando imagem de fundp
    int i, j;
    for(i = 0; i < 800; i++)
    {
        for(j = 0; j < 600; j++)
            tela->SetRGB(i, j, cor.Red(), cor.Green(), cor.Blue());
    }


    int k = 0;
    cor = wxString("BLACK");
	for( it = listaProc->begin(); it != listaProc->end() ; it++)
    {
        // desenhando marcador de tempo de criao do processo
        for(i = xInicial-3+larguraUnidadeTempo*(it->GetTCriacao());
            i < xInicial-3+larguraUnidadeTempo*(it->GetTCriacao())+5; i++)
        {
            for(j = yInicial-5+distanciaEntreLinhas*(listaProc->size() - it->GetId() -1);
                j < yInicial-5+distanciaEntreLinhas*(listaProc->size() - it->GetId() -1)+10; j++)
                tela->SetRGB(i, j, cor.Red(), cor.Green(), cor.Blue());
        }

        // desenhando as linhas dos procesos
        for(i = xInicial-3; i < xInicial-3+larguraUnidadeTempo*tempoTotal+6; i++)
            tela->SetRGB(i, yInicial+distanciaEntreLinhas*k, cor.Red(), cor.Green(), cor.Blue());
        k++;
    }

    // desenanhdo o eixo tempo
    for(i = xInicial-3; i < xInicial-3+larguraUnidadeTempo*tempoTotal+6; i++)
        tela->SetRGB(i, yInicial+distanciaEntreLinhas*k, cor.Red(), cor.Green(), cor.Blue());

    // desenhando o eixo processos
    for(j = yInicial-5; j < yInicial+listaProc->size()*distanciaEntreLinhas+5; j++)
        tela->SetRGB(xInicial, j, cor.Red(), cor.Green(), cor.Blue());

    cor = "GRAY";
    for(i = 1; i < tempoTotal+1; i++)
    {
        for(j = yInicial-5; j < yInicial+listaProc->size()*distanciaEntreLinhas+5; j++)
            tela->SetRGB(xInicial+larguraUnidadeTempo*i, j, cor.Red(), cor.Green(), cor.Blue());
    }

    wxCommandEvent evento;
    switch (tipoSimulacao)
    {
        case 0:
            passo_a_passo = true;
            break;
        case 1:
            passo_a_passo = false;
            for(i = 0; i < tempoTotal+1; i++)
                OnTic(evento);
            break;
        default: break;
    }

    Refresh();
}

void MyFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc( this );
    PrepareDC( dc );
    int i;
    wxString str;

    wxMemoryDC mem;
    mem.SelectObject(*tela);

    dc.Blit(0, 0, 800, 600, &mem, 0, 0);

    dc.SetTextForeground("BLUE");

    dc.DrawText("SIMULADOR DE ESCALONAMENTO DE PROCESSOS", 150, 20);
    dc.DrawText("Departamento de Cincia da Computao", 150, 45);
    dc.DrawText("Universidade Federal de Lavras", 150, 65);

    dc.SetTextForeground("BLACK");

    // desenhando os rtulos do eixo processos
    for(i = 0; i < listaProc->size(); i++)
    {
        str = "P";
        str << i;
        dc.DrawText(str, xInicial-25, yInicial-5+distanciaEntreLinhas*(listaProc->size()-i-1));
    }

    // desenhando os rtulos do eixo tempo
    for(i = 0; i < tempoTotal; i++)
    {
        str = "t";
        str << i;
        dc.DrawText(str, xInicial-5+larguraUnidadeTempo*i,
                    yInicial+distanciaEntreLinhas*listaProc->size()+5);
    }
}



