//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classe clProcesso                                                                       //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyright(c):   Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

#ifndef CLPROCESSO_H
#define CLPROCESSO_H

using namespace std;

//=================================================================================================
//  Assinatura da classe clProcesso
//=================================================================================================
class clProcesso
{
    public:
        clProcesso();
        clProcesso( int i, int tc, int tp );
        clProcesso(const clProcesso &p);
        ~clProcesso();
        void SetTCriacao( int tc );
        bool IncStatus( int st );
        void SetTProcessamento( int tp );
        void SetTFinalizacao( int t );
        int GetId() const;
        int GetTCriacao() const;
        int GetStatus() const;
        int GetTurnAround() const;
        int GetTProcessamento() const;        
        int GetTFinalizacao() const;
        void operator=( const clProcesso &p );
        bool GetEmUso() const;
        void SetEmUso(bool f);
    
    private:
        int id;             //Identificador do processo
        int tCriacao;       //Tempo de criacao do processo
        int status;         //Status do processo
        int turnAround;     //Turn around
        int tProcessamento; //Tempo de processamento
        int tFinalizacao;            
        bool emUso;
        

        //==========================================================================
        //  Funcoes utilitarias da classe
        //==========================================================================
        void CalculaTurnAround();        
};

//=================================================================================================
//  Definicao da construtor default
//=================================================================================================
clProcesso::clProcesso()
{
    id              = 0;
    tCriacao        = 0;
    status          = 0;
    turnAround      = 0;
    tProcessamento  = 0;
    tFinalizacao    = 0;
    emUso           = false;
}

//=================================================================================================
//  Definicao da construtor de cpia
//=================================================================================================
clProcesso::clProcesso(const clProcesso &p)
{
    id = p.id;
    tCriacao = p.tCriacao;
    status = p.status;
    turnAround = p.turnAround;
    tProcessamento = p.tProcessamento;
    tFinalizacao = p.tFinalizacao;
    emUso = p.emUso;
}

//=================================================================================================
//  Definicao da construtor default
//=================================================================================================
clProcesso::clProcesso( int i, int tc, int tp )
{
    id              = i;
    tCriacao        = tc;
    tProcessamento  = tp;
    status          = 0;
    turnAround      = 0;
    tFinalizacao    = 0;
    emUso           = false;
}

//=================================================================================================
//  Definicao do destrutor da classe clProcesso
//=================================================================================================
clProcesso::~clProcesso() {}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::SetTCriacao( int tc )
{
    tCriacao = tc;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
bool clProcesso::GetEmUso() const
{
    return emUso;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::SetEmUso(bool f)
{
    emUso = f;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
bool clProcesso::IncStatus( int tl )
{
    if( status < tProcessamento )
    {
        status++;        

        if( status == tProcessamento)
            SetTFinalizacao(++tl);
        
        return true;
    }    
    else
    {
//        SetTFinalizacao(tl);
        CalculaTurnAround();    
    }
    return false;   
}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::CalculaTurnAround()
{
    turnAround = tFinalizacao - tCriacao;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::SetTProcessamento( int tp )
{
    tProcessamento = tp;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::SetTFinalizacao( int t )
{
    tFinalizacao = t; 
}

//=================================================================================================
//  Definicao 
//=================================================================================================
int clProcesso::GetId() const
{
    return id;
}
//=================================================================================================
//  Definicao 
//=================================================================================================
int clProcesso::GetTCriacao() const
{
    return tCriacao;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
int clProcesso::GetStatus() const
{
    return status; 
}

int clProcesso::GetTurnAround() const
{
    return turnAround; 
}

//=================================================================================================
//  Definicao 
//=================================================================================================
int clProcesso::GetTProcessamento() const
{
    return tProcessamento;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
int clProcesso::GetTFinalizacao() const
{
    return tFinalizacao;
}

//=================================================================================================
//  Definicao 
//=================================================================================================
void clProcesso::operator=( const clProcesso &p )
{
    id              = p.GetId();
    tCriacao        = p.GetTCriacao();
    status          = p.GetStatus();
    turnAround      = p.GetTurnAround();
    tProcessamento  = p.GetTProcessamento();
    tFinalizacao    = p.GetTFinalizacao();
}

#endif

