//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classe FILA                                                                             //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyright(c):   Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

#ifndef CLFCFS_H 
#define CLFCFS_H 

#include <deque>

#include "clprocesso.h"

using namespace std;

//=================================================================================================
//  Assinatura da classe clProcesso
//=================================================================================================
class clFcfs
{
    public:
        clFcfs();
        clFcfs( deque< clProcesso > *p );
        ~clFcfs();
        int Tic();
            
    private:
        deque< clProcesso >       *filaProcessos;        //Fila de processos a serem executados 
        deque< clProcesso >       *listaProcessos;
        int                       timeLine;
        clProcesso                *procAtual;   
};

//=================================================================================================
//  Construtor
//=================================================================================================
clFcfs::clFcfs()
{
    filaProcessos  = NULL;
    procAtual      = NULL;
    timeLine       = 0;
}

//=================================================================================================
//  Construtor
//=================================================================================================
clFcfs::clFcfs( deque< clProcesso > *p )
{
    filaProcessos      = new deque< clProcesso >;
    listaProcessos     = p;
    procAtual          = NULL;
    timeLine           = 0;
}

//=================================================================================================
//  Destrutor
//=================================================================================================
clFcfs::~clFcfs()
{
    delete filaProcessos;
}

//=================================================================================================
//  Funcao que alguem vai comentar
//=================================================================================================
int clFcfs::Tic()
{
    deque< clProcesso >::iterator it = listaProcessos->begin();
    while( it != listaProcessos->end() )
    {
        if( (*it).GetTCriacao() == timeLine && !((*it).GetEmUso()))
        {
            filaProcessos->push_back( (*it) );
            (*it).SetEmUso(true);
        }
        it++;
    }

    if( procAtual == NULL )
        procAtual = new clProcesso(filaProcessos->front());

    if( procAtual->IncStatus(timeLine) )
        timeLine++;
    else if (!filaProcessos->empty())
    {
        deque< clProcesso >::iterator it = listaProcessos->begin();
        while(it != listaProcessos->end() && (procAtual->GetId() != (*it).GetId())){it++;}

        (*it) = *procAtual;
        filaProcessos->pop_front();
        *procAtual = filaProcessos->front();
        return -1;
    }
    return procAtual->GetId();
}

#endif

