//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classe clSJF                                                                            //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyleft(c):    Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

#ifndef CLSJF_H 
#define CLSJF_H 

#include <deque>

#include "clprocesso.h"

using namespace std;

//=================================================================================================
//  Assinatura da classe clProcesso
//=================================================================================================
class clSJF
{
    public:
        clSJF();
        clSJF( deque< clProcesso > *p );
        ~clSJF();
        int Tic();
            
    private:
        deque< clProcesso >       *filaProcessos;     
        deque< clProcesso >       *listaProcessos;
        int                       timeLine;
        clProcesso                *procAtual; 
        
        //================================================================================  
        //  Funcoes auxiliares da classe
        //================================================================================  
        void GetMenor( clProcesso *p );
};

//=================================================================================================
//  Construtor
//=================================================================================================
clSJF::clSJF()
{
    filaProcessos  = NULL;
    procAtual      = NULL;
    timeLine       = 0;
}

//=================================================================================================
//  Construtor
//=================================================================================================
clSJF::clSJF( deque< clProcesso > *p )
{
    filaProcessos      = new deque< clProcesso >;
    listaProcessos     = p;
    procAtual          = NULL;
    timeLine           = 0;
}

//=================================================================================================
//  Destrutor
//=================================================================================================
clSJF::~clSJF()
{
    delete filaProcessos;
}

//=================================================================================================
//  Funcao que alguem vai comentar
//=================================================================================================
int clSJF::Tic()
{
    clProcesso *p;

    p = new clProcesso;

    deque< clProcesso >::iterator it = listaProcessos->begin();
    while( it != listaProcessos->end() )
    {
        if( (*it).GetTCriacao() == timeLine && !((*it).GetEmUso()))
        {
            filaProcessos->push_back( (*it) );
            (*it).SetEmUso(true);
        }
        it++;
    }

    GetMenor( p );

    if( procAtual == NULL && p != NULL )
        procAtual = new clProcesso( *p );

    if( procAtual->IncStatus(timeLine) )
        timeLine++;
    else if (!filaProcessos->empty())
    {
        deque< clProcesso >::iterator it = listaProcessos->begin();
        while(it != listaProcessos->end() && (procAtual->GetId() != (*it).GetId())){it++;}
        (*it) = *procAtual;
        deque< clProcesso >::iterator it1 = filaProcessos->begin();
        while( it1 != filaProcessos->end() && (procAtual->GetId() != (*it1).GetId())){it1++;}
		filaProcessos->erase( it1 );
		GetMenor( p );
        procAtual = p;
        return -1;
    }
    return procAtual->GetId();
}

//=================================================================================================
//  Funcao que alguem vai comentar
//=================================================================================================
void clSJF::GetMenor( clProcesso *p )
{
    int tp;

    if( !filaProcessos->empty() )
    {
        tp = filaProcessos->front().GetTProcessamento(); 
        *p  = filaProcessos->front();
        deque< clProcesso >::iterator it = filaProcessos->begin() + 1;                
        while( it != filaProcessos->end() )
        {
            if( tp > it->GetTProcessamento() )
            {
                *p  = *it; 
                tp = it->GetTProcessamento();
            }        
            it++;
        }
    }
}

#endif


