//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classe ROUND_ROBIN                                                                      //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyright(c):   Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

#ifndef CLROUND_ROBIN_H 
#define CLROUND_ROBIN_H 

#include <deque>

#include "clprocesso.h"

using namespace std;

//=================================================================================================
//  Assinatura da classe clProcesso
//=================================================================================================
class clRoundRobin
{
    public:
        clRoundRobin();
        clRoundRobin( deque< clProcesso > *p, int qt );
        ~clRoundRobin();
        int Tic();
            
    private:
        deque< clProcesso >       *filaProcessos;    
        deque< clProcesso >       *listaProcessos;
        deque< clProcesso >       *listaAux;
        int                       timeLine;
        int                       quantum;
        int                       qAtual;
        clProcesso                *procAtual;   
};

//=================================================================================================
//  Construtor
//=================================================================================================
clRoundRobin::clRoundRobin()
{
    filaProcessos  = NULL;
    procAtual      = NULL;
    timeLine       = 0;
    quantum        = 1;
    qAtual         = 0;
}

//=================================================================================================
//  Construtor
//=================================================================================================
clRoundRobin::clRoundRobin( deque< clProcesso > *p, int qt )
{
    filaProcessos      = new deque< clProcesso >;
    listaAux           = new deque< clProcesso >;
    listaProcessos     = p;
    procAtual          = NULL;
    timeLine           = 0;
    quantum            = qt;
    qAtual             = 0;
}

//=================================================================================================
//  Destrutor
//=================================================================================================
clRoundRobin::~clRoundRobin()
{
    delete filaProcessos;
    delete listaAux;
}

//=================================================================================================
//  Funcao que alguem vai comentar
//=================================================================================================
int clRoundRobin::Tic()
{
    deque< clProcesso >::iterator it = listaProcessos->begin();
    while( it != listaProcessos->end() )
    {
        if( (*it).GetTCriacao() == timeLine && !((*it).GetEmUso()))
        {
            listaAux->push_back( (*it) );
            (*it).SetEmUso(true);
        }
        it++;
    }
    
    if( procAtual == NULL )
    {
        deque< clProcesso >::iterator itAux = listaAux->begin();                        
        while( itAux != listaAux->end())
        {
            filaProcessos->push_back(*itAux);
            itAux++;
        }
        listaAux->clear();
        procAtual = new clProcesso(filaProcessos->front());
    }

    if(qAtual < quantum)
    {
        qAtual++;
        if( procAtual->IncStatus(timeLine))
        {
            deque< clProcesso >::iterator itAux = listaAux->begin();                        
            while( itAux != listaAux->end())
            {
                filaProcessos->push_back(*itAux);
                itAux++;
            }
            listaAux->clear();
            timeLine++;
        }
        else if (!filaProcessos->empty())
        {
            qAtual = 0;
            
            deque< clProcesso >::iterator itAux = listaAux->begin();                        
            while( itAux != listaAux->end())
            {
                filaProcessos->push_back(*itAux);
                itAux++;
            }
            listaAux->clear();
    
            deque< clProcesso >::iterator it = listaProcessos->begin();
            while(it != listaProcessos->end() && (procAtual->GetId() != (*it).GetId())){it++;}
            
            (*it) = *procAtual;
            filaProcessos->pop_front();
            *procAtual = filaProcessos->front();

            return -1;
        }
    }
    else
    {
        qAtual = 0;
        filaProcessos->push_back(*procAtual);
        filaProcessos->pop_front();

        deque< clProcesso >::iterator itAux = listaAux->begin();
        while( itAux != listaAux->end())
        {
            filaProcessos->push_back(*itAux);
            itAux++;
        }
        listaAux->clear();
        *procAtual = filaProcessos->front();

        return -1;
    }
    return procAtual->GetId();
}

#endif

