//*************************************************************************************************
//*     Sistemas Operacionais - Politicas de Escalonamento                                      //*
//*     Classe RJF                                                                              //*
//*                                                                                             //*    
//*************************************************************************************************
//* Copyright(c):   Adriano Arlei De Carvalho                                                   //*        
//*                 Andreia Assuncao Schneider                                                  //*    
//*                 Anderson De Resende Rocha                                                   //*       
//*                 Antonio Galvao De Rezendo Filho                                             //*
//*                 Julio Cesar Alves                                                           //*
//*************************************************************************************************

#ifndef CLRJF_H 
#define CLRJF_H 


#include <deque>

#include "clprocesso.h"

//using namespace std;

//=================================================================================================
//  Assinatura da classe clProcesso
//=================================================================================================
class clRJF
{
    public:
        clRJF();
        clRJF( deque< clProcesso > *p );
        void GetMenor( clProcesso *p );
        void RemoverMenorFila( clProcesso *p );
        ~clRJF();
        int Tic();

    private:
        deque< clProcesso >       *filaProcessos;
        deque< clProcesso >       *listaProcessos;
        deque< clProcesso >       *listaAux;
        int                       timeLine;
        clProcesso                *procAtual;
        clProcesso                *menorFila;
};

//=================================================================================================
//  Construtor
//=================================================================================================
clRJF::clRJF()
{
    filaProcessos  = NULL;
    procAtual      = NULL;
    menorFila      = NULL;
    timeLine       = 0;
}

//=================================================================================================
//  Construtor
//=================================================================================================
clRJF::clRJF( deque< clProcesso > *p )
{
    filaProcessos      = new deque< clProcesso >;
    listaAux           = new deque< clProcesso >;
    listaProcessos     = p;
    procAtual          = NULL;
    menorFila          = NULL;
    timeLine           = 0;
}

//=================================================================================================
//  Destrutor
//=================================================================================================
clRJF::~clRJF()
{
    delete filaProcessos;
    delete listaAux;
}

//=================================================================================================
//  Funcao que alguem vai comentar
//=================================================================================================
int clRJF::Tic()
{
    deque< clProcesso >::iterator it = listaProcessos->begin();

    while( it != listaProcessos->end() )
    {
        if( (*it).GetTCriacao() == timeLine && !((*it).GetEmUso()))
        {
            filaProcessos->push_back( (*it) );
            (*it).SetEmUso(true);
        }
        it++;
    }

    if( procAtual == NULL )
    {
        procAtual = new clProcesso;
        menorFila = new clProcesso;
        GetMenor(procAtual);
    }

    GetMenor(menorFila);

    int menorAtual = procAtual->GetTProcessamento() - procAtual->GetStatus();
    int menorFuturo = menorFila->GetTProcessamento() - menorFila->GetStatus();

    if (menorAtual > menorFuturo)
        (*procAtual) = (*menorFila);

    if( procAtual->IncStatus(timeLine))
    {
        timeLine++;
        RemoverMenorFila(procAtual);
        filaProcessos->push_back(*procAtual);
    }
    else if (!filaProcessos->empty())
    {
        deque< clProcesso >::iterator it = listaProcessos->begin();
        while(it != listaProcessos->end() && (procAtual->GetId() != (*it).GetId())){it++;}

        (*it) = (*procAtual);
        RemoverMenorFila(procAtual);
        procAtual = NULL;

        return -1;
    }
    return procAtual->GetId();
}

void clRJF::RemoverMenorFila( clProcesso *p )
{
    deque< clProcesso >::iterator it = filaProcessos->begin();
    while(it->GetId() != p->GetId())
        it++;
    filaProcessos->erase(it);
}

void clRJF::GetMenor( clProcesso *p )
{
    int tpAux;
    int tpRestante;

    if( !filaProcessos->empty() )
    {
        tpRestante = filaProcessos->front().GetTProcessamento() - filaProcessos->front().GetStatus();
        *p  = filaProcessos->front();

        deque< clProcesso >::iterator it = filaProcessos->begin() + 1;
        while( it != filaProcessos->end() )
        {
            tpAux = it->GetTProcessamento() - it->GetStatus();
            if( tpRestante > tpAux )
            {
                *p  = *it; 
            }        
            it++;
        }
    }
}
#endif

