/********************************************************************
*                         ELO MALUCO                                *
* ----------------------------------------------------------------- *
*      Desenvolvedores:                                             *
*               Anderson de Rezende Rocha - DCC/UFLA                *
*	            undersun@comp.ufla.br                           *
*                                                                   *
*               Jlio Csar Alves - DCC/UFLA                        *
*	            jcalves@comp.ufla.br                            *
* ----------------------------------------------------------------- *
*    COMPUTACAO GRAFICA: Prof. Bruno Oliveira Schneider             *
********************************************************************/

/********************************************************************
*  Este arquivo contem a classe clPonto que define um ponto no      *
*  espaco tridimensional.                                           *
********************************************************************/

#ifndef PONTO_H
#define PONTO_H

// Definicao da classe
class clPonto
{
    public:
        // Construtor padrao inicia os valores das coordenadas com zero
        clPonto();
        clPonto(double umX, double umY, double umZ);
        ~clPonto() {}

        // Consultam as coordenadas
        double GetX();
        double GetY();
        double GetZ();

        // Modificam as coordenadas
        void SetX(double novoX);
        void SetY(double novoY);
        void SetZ(double novoZ);

    private:
        // Coordenadas do ponto
        double x;
        double y;
        double z;
};

// Construtor padrao inicia os valores das coordenadas com zero
clPonto::clPonto()
{
    SetX(0);
    SetY(0);
    SetZ(0);
}

// Construtor alternativo que recebe os valores das coordenadas
clPonto::clPonto(double umX, double umY, double umZ)
{
    SetX(umX);
    SetY(umY);
    SetZ(umZ);
}

// Retorna o valor da coordenada X
double clPonto::GetX()
{
    return x;
}

// Retorna o valor da coordenada Y
double clPonto::GetY()
{
    return y;
}

// Retorna o valor da coordenada Z
double clPonto::GetZ()
{
    return z;
}

// Modifica o valor da coordenada X
void clPonto::SetX(double novoX)
{
    x = novoX;
}

// Modifica o valor da coordenada Y
void clPonto::SetY(double novoY)
{
    y = novoY;
}

// Modifica o valor da coordenada Z
void clPonto::SetZ(double novoZ)
{
    z = novoZ;
}

#endif

