/*  Classe desenvolvida durante trabalho de Linguagens Formais e Automatos
    Curso de Ciencia da Computao - UFLA

    Desenvolvida por:
        Anderson de Rezende Rocha
        Flvio Lus Alves
        Jlio Csar Alves
        Rodrigo Nazar da Silva Leite
*/

#ifndef CLNOHLISTA_H
#define CLNOHLISTA_H



template <class TValor>
class clNohLista
// O operador = DEVE estar definido na classe TValor.
{
    public:
        clNohLista();           
        ~clNohLista();
        clNohLista *Proximo();
        TValor Valor();
        TValor *ValorRef();
        void CopiarValor(const TValor &v); 
        void Proximo(clNohLista *noh);     
    protected:
        TValor *valor;       
        clNohLista *proximo;  
};

template <class TValor>
clNohLista<TValor>::clNohLista()
{
    valor = NULL;
    proximo = NULL;
}

template <class TValor>
clNohLista<TValor>::~clNohLista()
{
    if (valor != NULL)
        delete valor;
}

template <class TValor>
TValor clNohLista<TValor>::Valor()
{
    return *valor;
}

template <class TValor>
TValor *clNohLista<TValor>::ValorRef()
{
    return valor;
}

template <class TValor>
clNohLista<TValor>* clNohLista<TValor>::Proximo()
// retorna o valor do proximo
{
    return proximo;
}

template <class TValor>
void clNohLista<TValor>::Proximo(clNohLista *noh)
// muda o valor do proximo
{
    proximo = noh;
}

template <class TValor>
void clNohLista<TValor>::CopiarValor(const TValor &v)
// muda o valor do noh
{
     if (valor != NULL)
        delete valor;
    valor = new TValor(v);
}

#endif

