/*  Classe desenvolvida durante trabalho de Linguagens Formais e Automatos
    Curso de Ciencia da Computao - UFLA

    Desenvolvida por:
        Anderson de Rezende Rocha
        Flvio Lus Alves
        Jlio Csar Alves
        Rodrigo Nazar da Silva Leite
*/

#ifndef CLLISTA_H
#define CLLISTA_H

#include <iostream>
#include "nohlista.h"

template <class TValor>
class clLista
{
    public:
        clLista();           
        clLista(const clLista<TValor> &lista); 
        ~clLista();           
        void Limpar();
        clNohLista<TValor> *Primeiro() const;
        void InserirNoFim(const TValor &val);
        // encontra e atualiza
        bool Encontrar(TValor& valor);

        void Imprimir();
    protected:
        clNohLista<TValor> *primeiro;   
};


template <class TValor>
bool clLista<TValor>::Encontrar(TValor& valor)
{
    if (primeiro != NULL)
    {
        clNohLista<TValor> *nohAux;
        nohAux = primeiro;
        while (nohAux != NULL)
        {
            if (valor == nohAux->Valor())
            {
                valor = nohAux->Valor();
                return true;
            }
            else
                nohAux = nohAux->Proximo();
        }
    }
    return false;
}

template <class TValor>
clLista<TValor>::clLista()
{
    primeiro = NULL;
}

template <class TValor>
clLista<TValor>::clLista(const clLista<TValor> &lista)
{
    clNohLista<TValor> *noh;

    // criar a lista vazia...
    primeiro = NULL;
    noh = lista.Primeiro();

    // ... e copiar cada elemento
    while (noh != NULL)
    {
        InserirNoFim(noh->Valor());
        noh = noh->Proximo();
    }
}

template <class TValor>
void clLista<TValor>::Limpar()
// Apaga todos elementos da lista, tornando-a vazia
{
    clNohLista<TValor> *aux;

    // destruir todos os nohs da lista
    aux = primeiro;
    while(aux != NULL)
    {
        primeiro = aux->Proximo();
        delete aux;
        aux = primeiro;
    }
}


template <class TValor>
clLista<TValor>::~clLista()
{
    Limpar(); //remover todos os nohs
}

template <class TValor>
clNohLista<TValor> *clLista<TValor>::Primeiro() const
{
    return primeiro;
}

template <class TValor>
void clLista<TValor>::InserirNoFim(const TValor &val)
// Insere UMA COPIA do valor passado no fim da lista
{
    clNohLista<TValor> *atual;
    clNohLista<TValor> *anterior;

    atual = primeiro;
    anterior = NULL;

    while (atual != NULL)
    {
        anterior = atual;
        atual = atual->Proximo();
    }
    atual = new clNohLista<TValor>;
    atual->CopiarValor(val);
    if (anterior == NULL)
        primeiro = atual;
    else
        anterior->Proximo(atual);
}

template <class TValor>
void clLista<TValor>::Imprimir()
{
    clNohLista<TValor> *noh;

    noh = primeiro;

    while (noh != NULL)
    {
        noh->Valor().Imprimir();
        noh = noh->Proximo();
    }
}

#endif
