/********************************************************************
*                         ELO MALUCO                                *
* ----------------------------------------------------------------- *
*      Desenvolvedores:                                             *
*               Anderson de Rezende Rocha - DCC/UFLA                *
*               undersun@comp.ufla.br                               *
*                                                                   *
*               Jlio Csar Alves - DCC/UFLA                        *
*               jcalves@comp.ufla.br                                *
* ----------------------------------------------------------------- *
*    COMPUTACAO GRAFICA: Prof. Bruno Oliveira Schneider             *
********************************************************************/

/********************************************************************
*  Este arquivo contem a classe clFace que define uma face do Elo   *
*  Maluco.                                                          *
*  Ela utiliza os ENUMs Ecor, EParte e EIdTextura                   *
********************************************************************/

#ifndef FACE_H
#define FACE_H

#include "ponto.h"

// enum ECor
// Definicao de uma cor. O Elo Maluco possui elos de quatro cores:
// . Vermelha -> VM,
// . Verde -> VD,
// . Amarela -> AM,
// . Branca -> BR
// . e VZ representa a "cor" da face vazia
enum ECor {VM = 0, VD, AM, BR, VZ,};

// enum EParte
// A face pode representar:
// . A parte superior de um elo -> S
// . A parte de interseccao entre dois elos -> M (de "meio")
// . ou A parte inferior de um elo -> I
enum EParte {S = 0, M, I, V,};

// enum EIdTextura
// EIdTextura identifica qual eh a face.
// Eh formada por uma cor e uma parte. Ex:
// VMS -> representa uma face que contem a parte superior de um elo vermelho
enum EIdTextura {VMS = 0, VMM, VMI, VDS, VDM, VDI, AMS, AMM, AMI, BRS, BRM, BRI, VZO, };

// Definicao da classe clFace
// Uma face eh definida por:
// . uma cor
// . uma parte
// . os dois anteriores formam um idTextura
// . e quatro pontos em um espaco tridimensional
class clFace
{
    public:
        clFace();
        clFace(ECor umaCor, EParte umaParte, clPonto pt1, clPonto pt2,
               clPonto pt3, clPonto pt4);
        ~clFace();
        clFace(const clFace &face);

        // Retorna a cor da face
        ECor GetCor();
        // Retorna a parte do elo que a face contem
        EParte GetParte();
        // Retornam os pontos no espaco tridimensional
        clPonto GetPonto1();
        clPonto GetPonto2();
        clPonto GetPonto3();
        clPonto GetPonto4();
        // Retorna o identificador da face
        EIdTextura GetIdTextura();
        
        // Modifica a cor da face
        void SetCor(ECor umaCor);
        // Modifica a parte do elo que a face contem
        void SetParte(EParte umaParte);
        // Modificam os pontos no espaco tridimensional
        void SetPonto1(clPonto pt1);
        void SetPonto2(clPonto pt2);
        void SetPonto3(clPonto pt3);
        void SetPonto4(clPonto pt4);               
        
        // Retorna uma copia da face
        void Copiar(const clFace &face);
               
    private:
        
        // O idTextura depende da cor e da parte da face.
        // Assim ao modificar um deles eh necessario atualiza-lo
        void AtualizarIdTextura();
        
        // Cor da face
        ECor cor;
        // Cor da parte
        EParte parte;
        // Pontos da face no espaco tridimensional
        clPonto ponto1;
        clPonto ponto2;
        clPonto ponto3;
        clPonto ponto4;
        EIdTextura idTextura;
};

clFace::clFace()
{
    clPonto ponto(0.0,0.0,0.0);
    
    SetCor(VZ);
    SetParte(V);
    SetPonto1(ponto);
    SetPonto2(ponto);
    SetPonto3(ponto);
    SetPonto4(ponto);
}

clFace::clFace(ECor umaCor, EParte umaParte, clPonto pt1, clPonto pt2, 
               clPonto pt3, clPonto pt4)
{
    SetCor(umaCor);
    SetParte(umaParte);
    SetPonto1(pt1);
    SetPonto2(pt2);
    SetPonto3(pt3);
    SetPonto4(pt4);
}

clFace::~clFace()
{
}

clFace::clFace(const clFace &face)
{
    SetCor(face.cor);
    SetParte(face.parte);
    SetPonto1(face.ponto1);
    SetPonto2(face.ponto2);
    SetPonto3(face.ponto3);
    SetPonto4(face.ponto4);
}    
        
// consultas
ECor clFace::GetCor()
{
    return cor;
}

EParte clFace::GetParte()
{
    return parte;
}

clPonto clFace::GetPonto1()
{
    return ponto1;
}

clPonto clFace::GetPonto2()
{
    return ponto2;
}

clPonto clFace::GetPonto3()
{
    return ponto3;
}

clPonto clFace::GetPonto4()
{
    return ponto4;
}

EIdTextura clFace::GetIdTextura()
{
    return idTextura;
}

// Sets
void clFace::SetCor(ECor umaCor)
{
    cor = umaCor;
    AtualizarIdTextura();
}

void clFace::SetParte(EParte umaParte)
{
    parte = umaParte;
    AtualizarIdTextura();
}

void clFace::SetPonto1(clPonto pt1)
{
    ponto1 = pt1;
}

void clFace::SetPonto2(clPonto pt2)
{
    ponto2 = pt2;
}

void clFace::SetPonto3(clPonto pt3)
{
    ponto3 = pt3;
}

void clFace::SetPonto4(clPonto pt4)
{
    ponto4 = pt4;
}

void clFace::AtualizarIdTextura()
{
    int cor = static_cast<int>(GetCor());
    int parte = static_cast<int>(GetParte());
    
    int codigo = cor*4+parte;
    
    switch (codigo)
    {
        case 0:
            idTextura = VMS;
            break;
        case 1:
            idTextura = VMM;
            break;            
        case 2:
            idTextura = VMI;
            break;            
        case 4:
            idTextura = VDS;
            break;            
        case 5:
            idTextura = VDM;
            break;            
        case 6:
            idTextura = VDI;
            break;            
        case 8:
            idTextura = AMS;
            break;                                                
        case 9:
            idTextura = AMM;
            break;
        case 10:
            idTextura = AMI;
            break;            
        case 12:
            idTextura = BRS;
            break;            
        case 13:
            idTextura = BRM;
            break;            
        case 14:
            idTextura = BRI;
            break;            
        case 19:
            idTextura = VZO;
            break;            
    }
}

void clFace::Copiar(const clFace &face)
{
    SetCor(face.cor);
    SetParte(face.parte);
}



#endif

       
