/********************************************************************
*                         ELO MALUCO                                *
* ----------------------------------------------------------------- *
*      Desenvolvedores:                                             *
*               Anderson de Rezende Rocha - DCC/UFLA                *
*               undersun@comp.ufla.br                               *
*                                                                   *
*               Jlio Csar Alves - DCC/UFLA                        *
*               jcalves@comp.ufla.br                                *
* ----------------------------------------------------------------- *
*    COMPUTACAO GRAFICA: Prof. Bruno Oliveira Schneider             *
********************************************************************/

/********************************************************************
*  Este arquivo contem a classe EloMalucoPanel que define um panel  *
*  para a utilizacao de botoes no programa                         *
********************************************************************/

#ifndef ELO_PANEL_H
#define ELO_PANEL_H

// timer.h -> para se utilizar um timer
#include <wx/timer.h>
// eloglcanvas.h -> define a classe EloMalucoGLcanvas
#include "eloglcanvas.h"

// definicao da classe EloMalucoPanel
class EloMalucoPanel : public wxPanel
{
    public:
        // construtor
        EloMalucoPanel(wxWindow *parent, int posX, int posY, int sizeX, int sizeY,
            long style = 0, const wxString& name = "EloMalucoPanel");
        // destrutor
        ~EloMalucoPanel();

        // Chamadas por botoes - apenas chamam funcoes da classe EloMalucoGLcanvas
        // por iss ha maiores explicacoes la
        // ____________________
        // faz o Elo Maluco parar de girar ou ficar girando
        void OnPararGirar(wxCommandEvent& event);
        // faz o Elo Maluco girar um pouco para a esquerda
        void OnGirarEsq(wxCommandEvent& event);
        // faz o Elo Maluco girar um pouco para a direita
        void OnGirarDir(wxCommandEvent& event);

        // rotaciona a parte superior do Elo Maluco a direita
        void OnRodarSupDir(wxCommandEvent& event);
        // rotaciona a parte superior do Elo Maluco a esquerda
        void OnRodarSupEsq(wxCommandEvent& event);
        // rotaciona a parte inferior do Elo Maluco a direita
        void OnRodarInfDir(wxCommandEvent& event);
        // rotaciona a parte inferior do Elo Maluco a esquerda
        void OnRodarInfEsq(wxCommandEvent& event);
        // move a face abaixo da face vazia para cima
        void OnMoverFacePCima(wxCommandEvent& event);
        // move a face acima da face vazia para baixo
        void OnMoverFacePBaixo(wxCommandEvent& event);

        // escolhe o modo de jogo entre: jogar ou ver solucao automatica
        void OnJogarOuSolucionar(wxCommandEvent& event);
        // executa um movimento para a solucao
        void OnAvancarSolucao(wxCommandEvent& event);
        // ________________________

        // chamada de tempos em tempos pre-determinados
        void OnTimer(wxTimerEvent &event);

        // o canvas do OpenGL
        EloMalucoGLCanvas* canvas;

    private:

        // botoes que executam as funcoes acima
        wxButton *rse;
        wxButton *rsd;
        wxButton *rie;
        wxButton *rid;
        wxButton *mfb;
        wxButton *mfc;
        wxButton *girarEsq;
        wxButton *girarDir;
        wxButton *jogarOuSolucionar;
        wxButton *avancarSolucao;
        wxButton *botaoPararGirar;

        // static box
        wxStaticBox *rs; // rotacionar superior
        wxStaticBox *ri; // rotacionar inferior
        wxStaticBox *mf; // mover face
	wxStaticBox *js; // jogar/solucionar

        // ainda sem utilidade
        wxStaticText *status;

        // timer
        wxTimer timer;

        DECLARE_EVENT_TABLE()
};

// identificadores para a tabela de eventos
enum { ID_RSE = 109, ID_RSD, ID_RIE, ID_RID, ID_MFB, ID_MFC,
       ID_JOG_SOL, ID_AV_S, ID_PG, ID_GE, ID_GD, ID_TIMER, };

BEGIN_EVENT_TABLE(EloMalucoPanel, wxPanel)
    EVT_BUTTON(ID_RSD, EloMalucoPanel::OnRodarSupDir)
    EVT_BUTTON(ID_RSE, EloMalucoPanel::OnRodarSupEsq)
    EVT_BUTTON(ID_RID, EloMalucoPanel::OnRodarInfDir)
    EVT_BUTTON(ID_RIE, EloMalucoPanel::OnRodarInfEsq)
    EVT_BUTTON(ID_MFB, EloMalucoPanel::OnMoverFacePBaixo)
    EVT_BUTTON(ID_MFC, EloMalucoPanel::OnMoverFacePCima)
    EVT_BUTTON(ID_PG, EloMalucoPanel::OnPararGirar)
    EVT_BUTTON(ID_GE, EloMalucoPanel::OnGirarEsq)
    EVT_BUTTON(ID_GD, EloMalucoPanel::OnGirarDir)
    EVT_BUTTON(ID_AV_S, EloMalucoPanel::OnAvancarSolucao)
    EVT_BUTTON(ID_JOG_SOL, EloMalucoPanel::OnJogarOuSolucionar)
    EVT_TIMER(ID_TIMER, EloMalucoPanel::OnTimer)
END_EVENT_TABLE()


// construtor
EloMalucoPanel::EloMalucoPanel(wxWindow *parent, int posX, int posY,
    int sizeX, int sizeY, long style, const wxString& name):
    wxPanel(parent, posX, posY, sizeX, sizeY, style, name),
           timer(this, ID_TIMER)
{
    // cira o canvas
    canvas = new EloMalucoGLCanvas(this, -1, wxPoint(190, 30), wxSize(300, 460));

    // cria os botoes e static box
    rs = new wxStaticBox(this, -1, "Rotacionar Parte Superior", wxPoint(8, 30), wxSize(170, 60));
    rse = new wxButton(this, ID_RSE, "<<", wxPoint(20,50), wxSize(70,25) );
    rsd = new wxButton(this, ID_RSD, ">>", wxPoint(95,50), wxSize(70,25) );
    ri = new wxStaticBox(this, -1, "Rotacionar Parte Inferior", wxPoint(8, 110), wxSize(170, 60));
    rie = new wxButton(this, ID_RIE, "<<", wxPoint(20,130), wxSize(70,25) );
    rid =  new wxButton(this, ID_RID, ">>", wxPoint(95,130), wxSize(70,25) );
    mf = new wxStaticBox(this, -1, "Mover Face Para", wxPoint(8, 190), wxSize(170, 60));
    mfb =  new wxButton(this, ID_MFB, "Baixo", wxPoint(20,210), wxSize(70,25) );
    mfc =  new wxButton(this, ID_MFC, "Cima", wxPoint(95,210), wxSize(70,25) );

    js = new wxStaticBox(this, -1, "Soluo Automtica", wxPoint(8, 270), wxSize(170, 60));
    jogarOuSolucionar =  new wxButton(this, ID_JOG_SOL, "Gerar", wxPoint(20,290), wxSize(70,25) );
    avancarSolucao = new wxButton(this, ID_AV_S, "Avanar", wxPoint(95,290), wxSize(70,25) );
    // desabilita o botao avancar
    avancarSolucao->Enable(false);

    girarEsq = new wxButton(this, ID_GE, "<< Girar", wxPoint(190,0) );
    botaoPararGirar = new wxButton(this, ID_PG, "Girando", wxPoint(297,0) );
    girarDir =  new wxButton(this, ID_GD, "Girar >>", wxPoint(404,0) );
}

EloMalucoPanel::~EloMalucoPanel()
{
    // desaloca tudo o que foi alocado
    delete canvas;
    delete botaoPararGirar;
    delete js;
    delete rs;
    delete ri;
    delete mf;
    delete rse;
    delete rsd;
    delete rie;
    delete rid;
    delete mfb;
    delete mfc;
    delete girarEsq;
    delete girarDir;
}

// chamado de tempos em tempos
void EloMalucoPanel::OnTimer(wxTimerEvent &event)
{
    // apenas manda redesenhar o canvas
    canvas->Desenhar();
//    canvas->Refresh();
}

// AS FUNCOES SAO ABIAXO SAO MELHORES EXPLICADAS NA CLASSE ELOMALUCOGLCANVAS, UMA VEZ
// QUE ELAS CHAMAM AS FUNCOES DE MESMO NOME DAQUELA CLASSE

void EloMalucoPanel::OnPararGirar(wxCommandEvent& event)
{
    bool parar = botaoPararGirar->GetLabel() == ((wxString)"Parado");
    canvas->PararGirar();

    // ajusta o texto do botao e o timer
    if(parar)
    {
        botaoPararGirar->SetLabel((wxString)"Girando");
        timer.Stop();
    }
    else
    {
        botaoPararGirar->SetLabel((wxString)"Parado");
        timer.Start(100);
    }
}

void EloMalucoPanel::OnGirarEsq(wxCommandEvent& event)
{
    canvas->GirarEsq();
}

void EloMalucoPanel::OnGirarDir(wxCommandEvent& event)
{
    canvas->GirarDir();
}

void EloMalucoPanel::OnRodarSupDir(wxCommandEvent& event)
{
    canvas->RodarSupDir();
}

void EloMalucoPanel::OnRodarSupEsq(wxCommandEvent& event)
{
    canvas->RodarSupEsq();
}

void EloMalucoPanel::OnRodarInfDir(wxCommandEvent& event)
{
    canvas->RodarInfDir();
}

void EloMalucoPanel::OnRodarInfEsq(wxCommandEvent& event)
{
    canvas->RodarInfEsq();
}

void EloMalucoPanel::OnMoverFacePCima(wxCommandEvent& event)
{
    canvas->MoverFacePCima();
}

void EloMalucoPanel::OnMoverFacePBaixo(wxCommandEvent& event)
{
    canvas->MoverFacePBaixo();
}

// escolhe entre o modos: jogar ou ver solucao
void EloMalucoPanel::OnJogarOuSolucionar(wxCommandEvent& event)
{
    if(jogarOuSolucionar->GetLabel() == (wxString)"Gerar")
    {
        if (canvas->GerarSolucao())
        {
            // ajusta o texto do botao
            jogarOuSolucionar->SetLabel((wxString)"Jogar");
            // desabilita os botoes de jogar
            rse->Enable(false);
            rsd->Enable(false);
            rie->Enable(false);
            rid->Enable(false);
            mfb->Enable(false);
            mfc->Enable(false);
            // habilita o botao avancar
            avancarSolucao->Enable(true);
        }
    }
    else
    {
        // desabilita o modo de solucao automatica
        canvas->modoSolucaoAutomatica = false;
        // ajusta o texto do botao
        jogarOuSolucionar->SetLabel((wxString)"Gerar");
        // reabilita os botoes de jogo
        rse->Enable(true);
        rsd->Enable(true);
        rie->Enable(true);
        rid->Enable(true);
        mfb->Enable(true);
        mfc->Enable(true);
        // desabilita o botao avancar
        avancarSolucao->Enable(false);
    }
}

// executa um movimento para a solucao do elo
void EloMalucoPanel::OnAvancarSolucao(wxCommandEvent& event)
{
    if (!canvas->AvancarSolucao())
    // se nao puder executar um movimento de solucao, reabilita o modo jogar
    {
        canvas->modoSolucaoAutomatica = false;
        jogarOuSolucionar->SetLabel((wxString)"Gerar Soluo");
        rse->Enable(true);
        rsd->Enable(true);
        rie->Enable(true);
        rid->Enable(true);
        mfb->Enable(true);
        mfc->Enable(true);
        avancarSolucao->Enable(false);
    }
}

#endif


