/********************************************************************
*                         ELO MALUCO                                *
* ----------------------------------------------------------------- *
*      Desenvolvedores:                                             *
*               Anderson de Rezende Rocha - DCC/UFLA                *
*               undersun@comp.ufla.br                               *
*                                                                   *
*               Jlio Csar Alves - DCC/UFLA                        *
*               jcalves@comp.ufla.br                                *
* ----------------------------------------------------------------- *
*    COMPUTACAO GRAFICA: Prof. Bruno Oliveira Schneider             *
********************************************************************/

/********************************************************************
*  Esta eh uma implementacao do jogo/brinquedo Elo Maluco           *
********************************************************************/

/********************************************************************
*  Este arquivo contem a classes EloMalucoApp que chama a aplicacao *
*  e a classe EloMalucoFrame que define um frame para o programa    *
********************************************************************/

// wx -> necessaria para se utilizar wxWindows
#include "wx/wx.h"
// elopanel.h -> define um panel a ser utilizado pelo programa
#include "elopanel.h"

// classe de aplicacao do wxWindows (como uma funcao int main())
class EloMalucoApp : public wxApp
{
public:
    virtual bool OnInit();
};

// definicao da classe EloMalucoFrame
class EloMalucoFrame : public wxFrame
{
    public:
        // contrutor
        EloMalucoFrame(wxFrame *frame, const wxString& title, const wxPoint& pos,
                const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);

        // executada ao fechar o programa
        void OnExit(wxCommandEvent& event);

        // embaralha o Elo Maluco
        void OnEmbaralharElo(wxMenuEvent& event);
        // salva o estado atual do Elo Maluco em um arquivo
        void OnSalvarEstado(wxMenuEvent& event);
        // carrega um estado do Elo Maluco a partir de um arquivo
        void OnCarregarEstado(wxMenuEvent& event);
        // Mostra a Ajuda
        void OnAjuda(wxMenuEvent& event);
        // sobre o programa desenvolvido
        void OnSobre(wxMenuEvent& event);

    private:
        // panel utilizado no programa
        EloMalucoPanel* panel;

        DECLARE_EVENT_TABLE()
};

// identificaores para a tabela de eventos
enum { ID_EMBARALHAR, ID_SALVAR, ID_CARREGAR, ID_SOBRE, ID_AJUDA};

BEGIN_EVENT_TABLE(EloMalucoFrame, wxFrame)
    EVT_MENU(ID_EMBARALHAR, EloMalucoFrame::OnEmbaralharElo)
    EVT_MENU(ID_CARREGAR, EloMalucoFrame::OnCarregarEstado)
    EVT_MENU(ID_SALVAR, EloMalucoFrame::OnSalvarEstado)
    EVT_MENU(ID_SOBRE, EloMalucoFrame::OnSobre)
    EVT_MENU(ID_AJUDA, EloMalucoFrame::OnAjuda)
    EVT_MENU(wxID_EXIT, EloMalucoFrame::OnExit)
END_EVENT_TABLE()

IMPLEMENT_APP(EloMalucoApp)

// chamada ao iniciar o programa
bool EloMalucoApp::OnInit()
{
    // cria-se o frame
    EloMalucoFrame *frame = new EloMalucoFrame(NULL, "Elo Maluco", wxPoint(50, 30),
                               wxSize(515, 580));
    frame->Show(TRUE);

    return TRUE;
}

// contrutor do frame
EloMalucoFrame::EloMalucoFrame(wxFrame *frame, const wxString& title, const wxPoint& pos,
                 const wxSize& size, long style)
         : wxFrame(frame, -1, title, pos, size, style)
{
    // cria o panel
    panel = new EloMalucoPanel(this, 0, 0, size.GetX(), size.GetY());


    // cria os menus para o frame
    wxMenu *menuArquivo = new wxMenu;
    wxMenu *menuAjuda = new wxMenu;
    menuArquivo->Append(ID_EMBARALHAR, "&Embaralhar Elo");
    menuArquivo->Append(ID_CARREGAR, "&Carregar Elo...");
    menuArquivo->Append(ID_SALVAR, "&Salvar Elo...");
    menuArquivo->AppendSeparator();
    menuArquivo->Append(wxID_EXIT, "&Fechar");

    menuAjuda->Append(ID_AJUDA, "&Ajuda...");
    menuAjuda->AppendSeparator();
    menuAjuda->Append(ID_SOBRE, "&Sobre...");


    wxMenuBar *barraDeMenu = new wxMenuBar;
    barraDeMenu->Append(menuArquivo, "A&rquivo");
    barraDeMenu->Append(menuAjuda, "A&juda");

    SetMenuBar(barraDeMenu);

    // cria uma barra de status
    CreateStatusBar(1);
    SetStatusText("Desenvolvido por: Anderson Rocha e Jlio Csar Alves");
}

// embaralha o elo
void EloMalucoFrame::OnEmbaralharElo(wxMenuEvent& event)
{
    panel->canvas->EmbaralharElo();
}

// salva o estado atual do elo em um arquivo
void EloMalucoFrame::OnSalvarEstado(wxMenuEvent& event)
{
    wxFileDialog dialogoArquivo(this, "Salvar Estado do Elo Maluco", "", "",
                                "*.elo", (wxSAVE | wxOVERWRITE_PROMPT));
    if(dialogoArquivo.ShowModal() == wxID_OK)
        panel->canvas->SalvarEstado(dialogoArquivo.GetPath());
}

// carrega um estado do elo a partir de um arquivo
void EloMalucoFrame::OnCarregarEstado(wxMenuEvent& event)
{
    wxFileDialog dialogoArquivo(this, "Carregar Estado do Elo Maluco", "", "",
                                "*.elo", (wxOPEN | wxFILE_MUST_EXIST));
    if(dialogoArquivo.ShowModal() == wxID_OK)
        panel->canvas->CarregarEstado(dialogoArquivo.GetPath());
}

// sobre o programa desenvolvido
void EloMalucoFrame::OnAjuda(wxMenuEvent& event)
{
    wxMessageBox("Este programa  baseado em um jogo chamado Elo Maluco ou Elo Mgico.\n"
                 "Para solucion-lo voc deve formar corretamente as correntes, ou seja,\n"
                 "formar quatro correntes uma de cada cor.\n\n"
                 "Para isso voc pode rotacionar a parte superior e inferior, para direita\n"
                 "e para a esquerda, e ainda mover a face proxima a face vazia (a face escura)\n"
                 "para baixo ou para cima. Para isso voc pode utilizar os botes ou o teclado.\n\n"
                 "Voc pode ainda girar o Elo para a direita ou para a esquerda, ou ainda\n"
                 "deix-lo girando.\n\n"
                 "Teclado:\nRotacionar parte superior  direita: Teclas E\n"
                 "Rotacionar parte superior  esquerda: Teclas Q\n"
                 "Rotacionar parte inferior  direita: Teclas D\n"
                 "Rotacionar parte inferior  esquerda: Teclas A\n"
                 "Mover face para cima: W\n"
                 "Mover face para baixo: S\n\n"
                 "Observao: depois que voc clica em um boto, para que o teclado funcione\n"
                 "voc deve passar o mouse sobre a rea do elo.", "Elo Maluco", wxOK);
}

// sobre o programa desenvolvido
void EloMalucoFrame::OnSobre(wxMenuEvent& event)
{
    wxMessageBox("Programa desenvolvido por:\n\n    Anderson de Rezende Rocha <undersun@comp.ufla.br>\n"
                 "    Jlio Csar Alves <jcalves@comp.ufla.br>\n\nDesenvolvido em C++, utiliza wxWindows\n"
                 "e OpenGL para os grficos 3D\n\nDisponivel em Linux ou Windows (FREEWARE)\n\n"
                 "Disciplina de Computao Grfica\n"
                 "Cincia da Computao\nUniversidade Federal de Lavras\n\n"
                 "Lavras, dezembro de 2002", "Elo Maluco", wxOK);
}

// executada ao fechar a janela
void EloMalucoFrame::OnExit(wxCommandEvent& event)
{
    // desaloca o panel
    delete panel;
    Destroy();
}

