/*
 * Decompiled with CFR 0.152.
 */
class SysTickRegister {
    public static final int COUNTFLAGBIT = 65536;
    public static final int CLOCKSOURCEBIT = 4;
    public static final int TICKINTBIT = 2;
    public static final int ENABLEBIT = 1;
    public static final int SYST_CSR = 0;
    public static final int SYST_RVR = 1;
    public static final int SYST_CVR = 2;
    public static final int SYST_CALIB = 3;
    private String name;
    private int type;
    public int value = 0;

    SysTickRegister(String string, int n) {
        this.name = string;
        this.type = n;
        if (n == 0) {
            this.value |= 4;
        }
    }

    public void setValue(int n) {
        switch (this.type) {
            case 0: {
                this.value = n & 0xFFFEFFFF;
                this.value |= 4;
                break;
            }
            case 2: {
                this.value = 0;
                SysTick.syst_csr.value &= 0xFFFEFFFF;
                break;
            }
            case 1: {
                SysTick.syst_rvr.value = this.value = n & 0xFFFFFF;
                break;
            }
        }
    }

    public int getValue() {
        switch (this.type) {
            case 0: {
                SysTick.syst_csr.value &= 0xFFFEFFFF;
                return this.value;
            }
            case 2: {
                return this.value;
            }
            case 1: {
                return this.value;
            }
            case 3: {
                return this.value;
            }
        }
        return 0;
    }
}

