/*
 * Decompiled with CFR 0.152.
 */
public class SysTick {
    private static int SYST_CSR_PORT = -536813552;
    private static int SYST_RVR_PORT = -536813548;
    private static int SYST_CVR_PORT = -536813544;
    private static int SYST_CALIB_PORT = -536813540;
    public static SysTickRegister syst_csr;
    public static SysTickRegister syst_rvr;
    public static SysTickRegister syst_cvr;
    public static SysTickRegister syst_calib;
    public static int SYST_CSR;
    public static int SYST_RVR;
    public static int SYST_CVR;
    public static int SYST_CALIB;

    public SysTick() {
        syst_csr = new SysTickRegister("syst_csr", SYST_CSR);
        syst_rvr = new SysTickRegister("syst_rvr", SYST_RVR);
        syst_cvr = new SysTickRegister("syst_cvr", SYST_CVR);
        syst_calib = new SysTickRegister("syst_calib", SYST_CALIB);
        IO.addDevice(SYST_CSR_PORT, "SYST_CSR", syst_csr);
        IO.addDevice(SYST_RVR_PORT, "SYST_RVR", syst_rvr);
        IO.addDevice(SYST_CVR_PORT, "SYST_CVR", syst_cvr);
        IO.addDevice(SYST_CALIB_PORT, "SYST_CALIB", syst_calib);
    }

    public static void clock(int n) {
        int n2 = syst_csr.getValue();
        if ((n2 & 1) != 0) {
            SysTick.syst_cvr.value -= n;
            if (SysTick.syst_cvr.value <= 0) {
                SysTick.syst_csr.value |= 0x10000;
                SysTick.syst_cvr.value = SysTick.syst_rvr.value;
                if ((SysTick.syst_csr.value & 2) != 0) {
                    // empty if block
                }
            }
        }
    }

    static {
        SYST_CSR = 0;
        SYST_RVR = 1;
        SYST_CVR = 2;
        SYST_CALIB = 3;
    }
}

