/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class SttySupport {
    private static String sttyCommand = System.getProperty("sshd.sttyCommand", "stty");
    private static String ttyProps;
    private static long ttyPropsLastFetched;

    public static Map<PtyMode, Integer> getUnixPtyModes() throws IOException, InterruptedException {
        return SttySupport.parsePtyModes(SttySupport.getTtyProps());
    }

    public static Map<PtyMode, Integer> parsePtyModes(String string) {
        TreeMap<PtyMode, Integer> treeMap = new TreeMap<PtyMode, Integer>();
        for (PtyMode ptyMode : PtyMode.values()) {
            int n;
            if (ptyMode == PtyMode.TTY_OP_ISPEED || ptyMode == PtyMode.TTY_OP_OSPEED) continue;
            String string2 = ptyMode.name().toLowerCase();
            if (string2.charAt(0) == 'v') {
                n = SttySupport.findChar(string, string2 = string2.substring(1));
                if (n < 0 && "reprint".equals(string2)) {
                    n = SttySupport.findChar(string, "rprnt");
                }
                if (n < 0) continue;
                treeMap.put(ptyMode, n);
                continue;
            }
            n = SttySupport.findFlag(string, string2);
            if (n < 0) continue;
            treeMap.put(ptyMode, n);
        }
        return treeMap;
    }

    private static int findFlag(String string, String string2) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(string2, n);
            int n3 = n2 + string2.length();
            if (n2 < 0) {
                return -1;
            }
            if (n2 > 0 && Character.isLetterOrDigit(string.charAt(n2 - 1)) || n3 < string.length() && Character.isLetterOrDigit(string.charAt(n3))) {
                n = n3;
                continue;
            }
            return n2 == 0 ? 1 : (string.charAt(n2 - 1) == '-' ? 0 : 1);
        }
        return -1;
    }

    private static int findChar(String string, String string2) {
        int n = 0;
        while (n < string.length()) {
            int n2 = string.indexOf(string2, n);
            int n3 = string.indexOf(61, n2);
            int n4 = string.indexOf(59, n2);
            if (n2 < 0 || n3 < 0 || n4 < n3) {
                return -1;
            }
            if (n2 > 0 && Character.isLetterOrDigit(string.charAt(n2 - 1)) || n3 < string.length() && Character.isLetterOrDigit(string.charAt(n3))) {
                n = n2 + string2.length();
                continue;
            }
            String string3 = string.substring(n3 + 1, n4 < 0 ? string.length() : n4).trim();
            if (string3.indexOf("undef") >= 0) {
                return -1;
            }
            if (string3.length() == 2 && string3.charAt(0) == '^') {
                int n5 = (string3.charAt(1) - 65 + 129) % 128;
                return n5;
            }
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        int n = -1;
        try {
            n = SttySupport.getTerminalProperty("columns");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 80;
        }
        return n;
    }

    public static int getTerminalHeight() {
        int n = -1;
        try {
            n = SttySupport.getTerminalProperty("rows");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == -1) {
            n = 24;
        }
        return n;
    }

    private static int getTerminalProperty(String string) throws IOException, InterruptedException {
        StringTokenizer stringTokenizer = new StringTokenizer(SttySupport.getTtyProps(), ";\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.startsWith(string)) {
                int n = string2.lastIndexOf(" ");
                return Integer.parseInt(string2.substring(n).trim());
            }
            if (!string2.endsWith(string)) continue;
            int n = string2.indexOf(" ");
            return Integer.parseInt(string2.substring(0, n).trim());
        }
        return -1;
    }

    public static String getTtyProps() throws IOException, InterruptedException {
        if (ttyProps == null || System.currentTimeMillis() - ttyPropsLastFetched > 1000L) {
            ttyProps = SttySupport.stty("-a");
            ttyPropsLastFetched = System.currentTimeMillis();
        }
        return ttyProps;
    }

    public static String stty(String string) throws IOException, InterruptedException {
        return SttySupport.exec("stty " + string + " < /dev/tty").trim();
    }

    public static String exec(String string) throws IOException, InterruptedException {
        return SttySupport.exec(new String[]{"sh", "-c", string});
    }

    private static String exec(String[] stringArray) throws IOException, InterruptedException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = process.getInputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        inputStream = process.getErrorStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        process.waitFor();
        String string = new String(byteArrayOutputStream.toByteArray());
        return string;
    }

    public static void setSttyCommand(String string) {
        sttyCommand = string;
    }

    public static String getSttyCommand() {
        return sttyCommand;
    }
}

