/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class MixedLeds
extends JComponent {
    private boolean[] led = new boolean[]{false, false, false, false, false, false, false, false};
    private char[] ledColor = new char[]{'r', 'r', 'r', 'r', 'r', 'r', 'r', 'r'};
    private int x;
    private int y;
    private int dx;
    private int dy;
    private int width;
    private int height;
    private static int num;
    private String color;
    private ImageIcon img_on_b;
    private ImageIcon img_off_b;
    private ImageIcon img_on_g;
    private ImageIcon img_off_g;
    private ImageIcon img_on_r;
    private ImageIcon img_off_r;
    private ImageIcon img_on_y;
    private ImageIcon img_off_y;

    public MixedLeds(String string, int n, int n2, int n3, int n4) {
        this.setOpaque(true);
        this.x = n;
        this.y = n2;
        this.dx = (n3 - n) / 8;
        this.width = n3 - n;
        this.height = n4 - n2;
        num = string.length();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < num; ++i) {
            this.ledColor[i] = cArray[i];
        }
        try {
            this.img_on_g = new ImageIcon(this.getClass().getResource("images/led_aceso_verde.png"));
            this.img_off_g = new ImageIcon(this.getClass().getResource("images/led_apagado_verde.png"));
            this.img_on_y = new ImageIcon(this.getClass().getResource("images/led_aceso_amarelo.png"));
            this.img_off_y = new ImageIcon(this.getClass().getResource("images/led_apagado_amarelo.png"));
            this.img_on_b = new ImageIcon(this.getClass().getResource("images/led_aceso_azul.png"));
            this.img_off_b = new ImageIcon(this.getClass().getResource("images/led_apagado_azul.png"));
            this.img_on_r = new ImageIcon(this.getClass().getResource("images/led_aceso_verm.png"));
            this.img_off_r = new ImageIcon(this.getClass().getResource("images/led_apagado_verm.png"));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    void setValue(int n) {
        for (int i = 0; i < num; ++i) {
            this.led[MixedLeds.num - i - 1] = (n & 1) == 1;
            n >>= 1;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(this.x, this.y, this.width, this.height);
        block12: for (int i = 0; i < num; ++i) {
            if (this.led[i]) {
                switch (this.ledColor[i]) {
                    case 'b': {
                        this.img_on_b.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                        break;
                    }
                    case 'g': {
                        this.img_on_g.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                        break;
                    }
                    case 'r': {
                        this.img_on_r.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                        break;
                    }
                    case 'y': {
                        this.img_on_y.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                    }
                }
                continue;
            }
            switch (this.ledColor[i]) {
                case 'b': {
                    this.img_off_b.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                    continue block12;
                }
                case 'g': {
                    this.img_off_g.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                    continue block12;
                }
                case 'r': {
                    this.img_off_r.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                    continue block12;
                }
                case 'y': {
                    this.img_off_y.paintIcon(this, graphics, 10 + (this.x + this.dx) * i, this.height / 2 - 20);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        String string = "bgry";
        MixedLeds mixedLeds = new MixedLeds(string, 0, 0, 400, 80);
        JFrame jFrame = new JFrame();
        jFrame.add(mixedLeds);
        jFrame.pack();
        jFrame.setSize(38 * string.length(), 100);
        jFrame.setVisible(true);
    }
}

