/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class LEG {
    public static final int MAXREGS = 16;
    public static final int SP = 15;
    public static final int FP = 14;
    public static final int MAXFLAGS = 7;
    public static Register[] Registers = new Register[16];
    public static long ip = 0L;
    public static long flags = 0L;
    public static long clock = 0L;
    public static long res = 0L;
    public static boolean in_wait_instr = false;
    public static final Flag CF = new Flag("C", 1L);
    public static final Flag ZF = new Flag("Z", 2L);
    public static final Flag NF = new Flag("N", 4L);
    public static final Flag TF = new Flag("T", 8L);
    public static final Flag IF = new Flag("I", 16L);
    public static final Flag VF = new Flag("V", 32L);
    public static final Flag SF = new Flag("S", 64L);
    public static final long MASK_32_SIGNBIT = Integer.MIN_VALUE;
    public static final long MASK_OVFBIT = -1073741824L;
    public static final long MASK_32_BITS = -1L;
    public static Set TwoWordInstructions = new HashSet();
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final byte SYSCALL = 85;
    public static final byte SYSEXIT = 1;
    public static final byte SYSREAD = 3;
    public static final byte SYSWRITE = 4;
    public static final byte SYSPRINT = 33;
    public static final byte SYSPUTC = 34;

    public static long pop() throws BreakException {
        long l = Memory.readword(LEG.Registers[15].value);
        LEG.Registers[15].value += 4L;
        return l;
    }

    public static void push(long l) throws BreakException {
        LEG.Registers[15].value -= 4L;
        Memory.writeword(LEG.Registers[15].value, l);
    }

    public LEG() {
        for (int i = 0; i < 14; ++i) {
            LEG.Registers[i] = new Register("r" + i);
        }
        LEG.Registers[i++] = new Register("fp");
        LEG.Registers[i++] = new Register("sp");
        flags |= LEG.SF.mask;
        TwoWordInstructions.add((byte)2);
        TwoWordInstructions.add((byte)3);
        TwoWordInstructions.add((byte)5);
        TwoWordInstructions.add((byte)7);
        TwoWordInstructions.add((byte)9);
        TwoWordInstructions.add((byte)32);
        TwoWordInstructions.add((byte)84);
    }

    public static void printmode() {
    }

    public void setProcessorMode(String string) {
        if (string.equals("user")) {
            flags &= LEG.SF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (string.equals("supervisor")) {
            flags |= LEG.SF.mask;
        }
    }

    public static Instruction ufetchInstr(long l) throws BreakException {
        Instruction instruction = new Instruction();
        instruction.reg2 = Memory.doreadbyte(l);
        instruction.reg1 = Memory.doreadbyte(l + 1L);
        instruction.imm8 = Memory.doreadbyte(l + 2L);
        instruction.code = Memory.doreadbyte(l + 3L);
        l += 4L;
        if (TwoWordInstructions.contains(instruction.code)) {
            instruction.imm32 = Memory.doreadword(l);
            l += 4L;
        } else {
            instruction.imm32 = -1L;
        }
        return instruction;
    }

    public static Instruction fetchInstr(long l) throws BreakException {
        Instruction instruction = new Instruction();
        instruction.reg2 = Memory.readbyte(l);
        instruction.reg1 = Memory.readbyte(l + 1L);
        instruction.imm8 = Memory.readbyte(l + 2L);
        instruction.code = Memory.readbyte(l + 3L);
        if (jsim.Traces.containsKey(l)) {
            long l2 = jsim.Traces.get(l);
            jsim.Traces.put(l, l2 + 1L);
        }
        if (!jsim.SingleStep && jsim.XBreaks.contains(l)) {
            throw new BreakException("EXECUTION BREAK", l);
        }
        if (instruction.reg1 >= 16 || instruction.reg2 >= 16) {
            throw new BreakException("INVALID REGISTER", l);
        }
        l += 4L;
        if (TwoWordInstructions.contains(instruction.code)) {
            if (!jsim.SingleStep && jsim.XBreaks.contains(l)) {
                throw new BreakException("EXECUTION BREAK", l);
            }
            instruction.imm32 = Memory.readword(l);
            l += 4L;
        } else {
            instruction.imm32 = -1L;
        }
        return instruction;
    }

    public static long unasblr(long l, long l2) throws BreakException {
        while (l2 > 0L) {
            Instruction instruction = LEG.ufetchInstr(l);
            if (jsim.UserSymbolsInv.containsKey(l)) {
                System.out.printf("%08x [%02x %02x %02x %02x] %-20s ", l, instruction.code, instruction.imm8, instruction.reg1, instruction.reg2, jsim.UserSymbolsInv.get(l) + ":");
            } else {
                System.out.printf("%08x [%02x %02x %02x %02x] %-20s ", l, instruction.code, instruction.imm8, instruction.reg1, instruction.reg2, "");
            }
            try {
                block1 : switch (instruction.code) {
                    case 0: {
                        System.out.printf("mov  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 1: {
                        System.out.printf("set  %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 2: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("set  %s,%s\n", LEG.Registers[instruction.reg1].name, jsim.UserSymbolsInv.get(instruction.imm32));
                            break;
                        }
                        System.out.printf("set  %s,0x%x\n", LEG.Registers[instruction.reg1].name, instruction.imm32);
                        break;
                    }
                    case 3: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("ld   %s,%s\n", LEG.Registers[instruction.reg1].name, jsim.UserSymbolsInv.get(instruction.imm32));
                            break;
                        }
                        System.out.printf("ld   %s,0x%x\n", LEG.Registers[instruction.reg1].name, instruction.imm32);
                        break;
                    }
                    case 4: {
                        if (instruction.imm8 != 0) {
                            byte by = instruction.imm8;
                            if (by > 0) {
                                System.out.printf("ld   %s,[%s+%d]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name, (int)by);
                                break;
                            }
                            System.out.printf("ld   %s,[%s%d]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name, (int)by);
                            break;
                        }
                        System.out.printf("ld   %s,[%s]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 5: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("st   %s,%s\n", jsim.UserSymbolsInv.get(instruction.imm32), LEG.Registers[instruction.reg2].name);
                            break;
                        }
                        System.out.printf("st   0x%x,%s\n", instruction.imm32, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 6: {
                        if (instruction.imm8 != 0) {
                            byte by = instruction.imm8;
                            if (by > 0) {
                                System.out.printf("st   [%s+%d],%s\n", LEG.Registers[instruction.reg1].name, (int)by, LEG.Registers[instruction.reg2].name);
                                break;
                            }
                            System.out.printf("st   [%s%d],%s\n", LEG.Registers[instruction.reg1].name, (int)by, LEG.Registers[instruction.reg2].name);
                            break;
                        }
                        System.out.printf("st   [%s],%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 7: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("ldb  %s,%s\n", LEG.Registers[instruction.reg1].name, jsim.UserSymbolsInv.get(instruction.imm32));
                            break;
                        }
                        System.out.printf("ldb  %s,0x%x\n", LEG.Registers[instruction.reg1].name, instruction.imm32);
                        break;
                    }
                    case 8: {
                        if (instruction.imm8 != 0) {
                            byte by = instruction.imm8;
                            if (by > 0) {
                                System.out.printf("ldb  %s,[%s+%d]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name, (int)by);
                                break;
                            }
                            System.out.printf("ldb  %s,[%s%d]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name, (int)by);
                            break;
                        }
                        System.out.printf("ldb  %s,[%s]\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 9: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("stb  %s,%s\n", jsim.UserSymbolsInv.get(instruction.imm32), LEG.Registers[instruction.reg2].name);
                            break;
                        }
                        System.out.printf("stb  0x%x,%s\n", instruction.imm32, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 10: {
                        if (instruction.imm8 != 0) {
                            byte by = instruction.imm8;
                            if (by > 0) {
                                System.out.printf("stb  [%s+%d],%s\n", LEG.Registers[instruction.reg1].name, (int)by, LEG.Registers[instruction.reg2].name);
                                break;
                            }
                            System.out.printf("stb  [%s%d],%s\n", LEG.Registers[instruction.reg1].name, (int)by, LEG.Registers[instruction.reg2].name);
                            break;
                        }
                        System.out.printf("stb  [%s],%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 16: {
                        System.out.printf("add  %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 17: {
                        System.out.printf("add  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 18: {
                        System.out.printf("sub  %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 19: {
                        System.out.printf("sub  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 20: {
                        System.out.printf("cmp  %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 21: {
                        System.out.printf("cmp  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 22: {
                        System.out.printf("adc  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 23: {
                        System.out.printf("sbb  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 32: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("jmp  %s\n", jsim.UserSymbolsInv.get(instruction.imm32));
                            break;
                        }
                        System.out.printf("jmp  0x%x\n", instruction.imm32);
                        break;
                    }
                    case 33: {
                        System.out.printf("jmp  %s\n", LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 31: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 46: 
                    case 47: {
                        long l3 = instruction.imm8;
                        String string = jsim.UserSymbolsInv.containsKey(l3 += l + 4L) ? jsim.UserSymbolsInv.get(l3) : "0x" + Long.toHexString(l3);
                        switch (instruction.code) {
                            case 34: {
                                System.out.printf("jc   %s\n", string);
                                break block1;
                            }
                            case 35: {
                                System.out.printf("jnc  %s\n", string);
                                break block1;
                            }
                            case 36: {
                                System.out.printf("jz   %s\n", string);
                                break block1;
                            }
                            case 37: {
                                System.out.printf("jnz  %s\n", string);
                                break block1;
                            }
                            case 38: {
                                System.out.printf("jo   %s\n", string);
                                break block1;
                            }
                            case 39: {
                                System.out.printf("jno  %s\n", string);
                                break block1;
                            }
                            case 40: {
                                System.out.printf("js   %s\n", string);
                                break block1;
                            }
                            case 41: {
                                System.out.printf("jns  %s\n", string);
                                break block1;
                            }
                            case 42: {
                                System.out.printf("jl   %s\n", string);
                                break block1;
                            }
                            case 43: {
                                System.out.printf("jle  %s\n", string);
                                break block1;
                            }
                            case 44: {
                                System.out.printf("jg   %s\n", string);
                                break block1;
                            }
                            case 46: {
                                System.out.printf("jge  %s\n", string);
                                break block1;
                            }
                            case 47: {
                                System.out.printf("ja   %s\n", string);
                                break block1;
                            }
                            case 31: {
                                System.out.printf("jna   %s\n", string);
                            }
                        }
                        break;
                    }
                    case 48: {
                        System.out.printf("and  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 49: {
                        System.out.printf("or   %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 50: {
                        System.out.printf("xor  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 51: {
                        System.out.printf("test %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 52: {
                        System.out.printf("not  %s\n", LEG.Registers[instruction.reg1].name);
                        break;
                    }
                    case 64: {
                        System.out.printf("shr  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 65: {
                        System.out.printf("shr  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 66: {
                        System.out.printf("shl  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 67: {
                        System.out.printf("shl  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 68: {
                        System.out.printf("sar  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 69: {
                        System.out.printf("sar  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 70: {
                        System.out.printf("rol  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 71: {
                        System.out.printf("rol  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 72: {
                        System.out.printf("ror  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 73: {
                        System.out.printf("ror  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 74: {
                        System.out.printf("rcl  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 75: {
                        System.out.printf("rcl  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 76: {
                        System.out.printf("rcr  %s,%d\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 77: {
                        System.out.printf("rcr  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 80: {
                        System.out.printf("push %s\n", LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 81: {
                        System.out.printf("pop  %s\n", LEG.Registers[instruction.reg1].name);
                        break;
                    }
                    case 82: {
                        System.out.printf("pushf\n", new Object[0]);
                        break;
                    }
                    case 83: {
                        System.out.printf("popf\n", new Object[0]);
                        break;
                    }
                    case 84: {
                        if (jsim.UserSymbolsInv.containsKey(instruction.imm32)) {
                            System.out.printf("call %s\n", jsim.UserSymbolsInv.get(instruction.imm32));
                            break;
                        }
                        System.out.printf("call 0x%x\n", instruction.imm32);
                        break;
                    }
                    case 85: {
                        System.out.printf("call %s\n", LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 86: {
                        System.out.printf("ret\n", new Object[0]);
                        break;
                    }
                    case 87: {
                        System.out.printf("sys  0x%02x\n", instruction.imm8);
                        break;
                    }
                    case 88: {
                        System.out.printf("iret\n", new Object[0]);
                        break;
                    }
                    case 96: {
                        System.out.printf("in   %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 97: {
                        System.out.printf("in   %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 98: {
                        System.out.printf("inb  %s,0x%02x\n", LEG.Registers[instruction.reg1].name, instruction.imm8);
                        break;
                    }
                    case 99: {
                        System.out.printf("inb  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 100: {
                        System.out.printf("out  0x%02x,%s\n", instruction.imm8, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 101: {
                        System.out.printf("out  %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 102: {
                        System.out.printf("outb 0x%02x,%s\n", instruction.imm8, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 103: {
                        System.out.printf("outb %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 112: {
                        System.out.printf("clc\n", new Object[0]);
                        break;
                    }
                    case 113: {
                        System.out.printf("stc\n", new Object[0]);
                        break;
                    }
                    case 114: {
                        System.out.printf("cli\n", new Object[0]);
                        break;
                    }
                    case 115: {
                        System.out.printf("sti\n", new Object[0]);
                        break;
                    }
                    case 116: {
                        System.out.printf("hlt\n", new Object[0]);
                        break;
                    }
                    case 117: {
                        System.out.printf("imul %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 118: {
                        System.out.printf("idiv %s,%s\n", LEG.Registers[instruction.reg1].name, LEG.Registers[instruction.reg2].name);
                        break;
                    }
                    case 119: {
                        System.out.printf("wait\n", new Object[0]);
                        break;
                    }
                    case 120: {
                        System.out.printf("drop\n", new Object[0]);
                        break;
                    }
                    default: {
                        System.out.printf("not a instruction\n", new Object[0]);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println();
            }
            if (TwoWordInstructions.contains(instruction.code)) {
                byte by = (byte)(instruction.imm32 & 0xFFL);
                byte by2 = (byte)(instruction.imm32 >> 8 & 0xFFL);
                byte by3 = (byte)(instruction.imm32 >> 16 & 0xFFL);
                byte by4 = (byte)(instruction.imm32 >> 24 & 0xFFL);
                System.out.printf("%08x [%02x %02x %02x %02x]\n", l += 4L, by4, by3, by2, by);
            }
            l += 4L;
            --l2;
        }
        return l;
    }

    public static void printflags() {
        if ((flags & LEG.SF.mask) != 0L) {
            System.out.print(LEG.SF.name);
        }
        if ((flags & LEG.ZF.mask) != 0L) {
            System.out.print(LEG.ZF.name);
        }
        if ((flags & LEG.CF.mask) != 0L) {
            System.out.print(LEG.CF.name);
        }
        if ((flags & LEG.VF.mask) != 0L) {
            System.out.print(LEG.VF.name);
        }
        if ((flags & LEG.NF.mask) != 0L) {
            System.out.print(LEG.NF.name);
        }
        if ((flags & LEG.TF.mask) != 0L) {
            System.out.print(LEG.TF.name);
        }
        if ((flags & LEG.IF.mask) != 0L) {
            System.out.print(LEG.IF.name);
        }
    }

    public static void PSZflagsw() {
        flags = (res & Integer.MIN_VALUE) != 0L ? (flags |= LEG.NF.mask) : (flags &= LEG.NF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        flags = (res & 0xFFFFFFFFFFFFFFFFL) != 0L ? (flags &= LEG.ZF.mask ^ 0xFFFFFFFFFFFFFFFFL) : (flags |= LEG.ZF.mask);
    }

    public static void OCflagw(int n, int n2) {
        boolean bl;
        boolean bl2 = ((long)n & Integer.MIN_VALUE) != 0L;
        boolean bl3 = ((long)n2 & Integer.MIN_VALUE) != 0L;
        boolean bl4 = bl = ((long)((int)res) & Integer.MIN_VALUE) != 0L;
        flags = bl3 & bl2 || !bl & bl2 || !bl & bl3 ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        flags = bl3 & bl2 & !bl || !bl3 & !bl2 & bl ? (flags |= LEG.VF.mask) : (flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void OCflagwsub(int n, int n2) {
        boolean bl = ((long)n & Integer.MIN_VALUE) != 0L;
        boolean bl2 = ((long)n2 & Integer.MIN_VALUE) != 0L;
        boolean bl3 = ((long)((int)res) & Integer.MIN_VALUE) != 0L;
        flags = bl2 & !bl || bl3 & !bl || bl3 & bl2 ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        flags = !bl2 & bl & !bl3 || bl2 & !bl & bl3 ? (flags |= LEG.VF.mask) : (flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void addw(long l, long l2) {
        int n = (int)l;
        int n2 = (int)l2;
        res = (long)n + (long)n2;
        LEG.PSZflagsw();
        LEG.OCflagw(n, n2);
    }

    public static void adcw(long l, long l2) {
        int n = (int)l;
        int n2 = (int)l2;
        res = (long)n + (long)n2;
        if ((flags & LEG.CF.mask) != 0L) {
            ++res;
        }
        LEG.PSZflagsw();
        LEG.OCflagw(n, n2);
    }

    public static void subw(long l, long l2) {
        int n = (int)l;
        int n2 = (int)l2;
        res = (long)n - (long)n2;
        LEG.PSZflagsw();
        LEG.OCflagwsub(n, n2);
    }

    public static void sbbw(long l, long l2) {
        int n = (int)l;
        int n2 = (int)l2;
        res = (long)n - (long)n2;
        if ((flags & LEG.CF.mask) != 0L) {
            --res;
        }
        LEG.PSZflagsw();
        LEG.OCflagwsub(n, n2);
    }

    public static void idiv(long l, long l2, long l3) {
        long l4 = l3;
        l4 &= 0xFFFFFFFFFFFFFFFFL;
        l4 <<= 32;
        long l5 = l2;
        long l6 = (l4 |= l) / (l5 &= 0xFFFFFFFFFFFFFFFFL);
        flags = l6 == 0L ? (flags |= LEG.ZF.mask) : (flags &= LEG.ZF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        l = l6;
        l3 = l6 = l4 % l2;
    }

    public static void imul(long l, long l2, long l3) {
        res = l * l2;
        flags = res == 0L ? (flags |= LEG.ZF.mask) : (flags &= LEG.ZF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (res >> 32 == 0L) {
            flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
            flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        } else {
            flags |= LEG.CF.mask;
            flags |= LEG.VF.mask;
        }
        l = res & 0xFFFFFFFFFFFFFFFFL;
        l3 = res >> 32;
    }

    public static void orw(int n, int n2) {
        res = n | n2;
        LEG.PSZflagsw();
        flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void andw(int n, int n2) {
        res = n & n2;
        LEG.PSZflagsw();
        flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void notw(int n) {
        res = ~n;
        LEG.PSZflagsw();
        flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void xorw(int n, int n2) {
        res = n ^ n2;
        LEG.PSZflagsw();
        flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void rcl(int n, byte by) {
        int n2 = 0;
        res = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            n2 = (int)(res & Integer.MIN_VALUE);
            res <<= 1;
            if ((flags & LEG.CF.mask) != 0L) {
                res |= 1L;
            }
            if (n2 != 0) {
                flags |= LEG.CF.mask;
                continue;
            }
            flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void rcr(int n, byte by) {
        res = n;
        int n2 = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            n2 >>>= 1;
            if ((flags & LEG.CF.mask) != 0L) {
                n2 = (int)((long)n2 | Integer.MIN_VALUE);
            }
            flags = (n & 1) != 0 ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
            n = n2;
        }
        res = n2;
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void rol(int n, byte by) {
        int n2 = 0;
        res = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            n2 = (int)(res & Integer.MIN_VALUE);
            res <<= 1;
            if (n2 != 0) {
                flags |= LEG.CF.mask;
                res |= 1L;
                continue;
            }
            flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void ror(int n, byte by) {
        int n2 = n;
        res = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            n2 = n >>> 1;
            if ((n & 1) != 0) {
                n2 = (int)((long)n2 | Integer.MIN_VALUE);
                flags |= LEG.CF.mask;
            } else {
                flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            n = n2;
        }
        res = n2;
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void sar(int n, byte by) {
        res = n;
        int n2 = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            flags = (n2 & 1) != 0 ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
            n2 >>= 1;
        }
        res = n2;
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void shr(int n, byte by) {
        res = n;
        int n2 = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            flags = (n & 1) != 0 ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
            n2 >>>= 1;
        }
        res = n2;
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void shl(int n, byte by) {
        long l = 0L;
        res = n;
        for (by = (byte)(by & 0x1F); by != 0; by = (byte)(by - 1)) {
            l = (long)((int)res) & Integer.MIN_VALUE;
            res <<= 1;
        }
        flags = l != 0L ? (flags |= LEG.CF.mask) : (flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL);
        LEG.PSZflagsw();
        flags &= LEG.VF.mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void intr(byte by) throws BreakException, IOException {
        int n = (int)Memory.readword(by << 2);
        Boolean bl = false;
        if (by == 85 && n == 0) {
            int n2 = (int)LEG.Registers[7].value;
            switch (n2) {
                case 3: {
                    int n3 = (int)LEG.Registers[0].value;
                    if (n3 != 0) break;
                    int n4 = (int)LEG.Registers[2].value;
                    int n5 = (int)LEG.Registers[1].value;
                    String string = jsim.Console.read_from_console();
                    if (n4 > string.length()) {
                        n4 = string.length();
                    }
                    for (int i = 0; i < n4; ++i) {
                        Memory.writebyte(n5++, (byte)string.charAt(i));
                    }
                    LEG.Registers[0].value = n4;
                    bl = true;
                    break;
                }
                case 4: {
                    int n6 = (int)LEG.Registers[0].value;
                    if (n6 != 1) break;
                    int n7 = (int)LEG.Registers[1].value;
                    int n8 = (int)LEG.Registers[2].value;
                    for (int i = 0; i < n8; ++i) {
                        byte by2 = Memory.readbyte(n7);
                        jsim.Console.write_to_console(Memory.readbyte(n7++));
                    }
                    LEG.Registers[0].value = n8;
                    bl = true;
                    break;
                }
                case 34: {
                    int n9 = (int)LEG.Registers[0].value;
                    if (n9 != 1) break;
                    int n10 = (int)LEG.Registers[1].value;
                    bl = true;
                    break;
                }
                case 33: {
                    int n11 = (int)LEG.Registers[1].value;
                    byte by3 = Memory.readbyte(n11++);
                    while (by3 != 0) {
                        by3 = Memory.readbyte(n11++);
                        LEG.Registers[0].value = 0L;
                        bl = true;
                    }
                    break;
                }
                case 1: {
                    throw new BreakException("EXIT ", (ip += 4L) - 4L);
                }
                default: {
                    throw new BreakException("UNKNOWN O.S. SERVICE ", ip - 4L);
                }
            }
        }
        if (!bl.booleanValue()) {
            LEG.push(flags);
            flags &= LEG.TF.mask + LEG.IF.mask ^ 0xFFFFFFFFFFFFFFFFL;
            flags |= LEG.SF.mask;
            LEG.push(ip);
            ip = Memory.readword(by << 2);
        }
    }

    public static void sim() throws BreakException, IOException {
        Object object;
        if (IO.mapCmd.containsKey(++clock)) {
            object = IO.mapCmd.get(clock);
            if (((String)object).charAt(0) == 'q') {
                jsim.stop = true;
            } else {
                String[] stringArray = ((String)object).split(" ");
                int n = IO.read_integer(stringArray[0]);
                int n2 = IO.read_integer(stringArray[1]);
                IO.outb(n, (byte)n2);
            }
        }
        if (IO.interruptQueue.peek() != null && (flags & LEG.IF.mask) != 0L) {
            int n = IO.interruptQueue.remove();
            if (in_wait_instr) {
                in_wait_instr = false;
                ip += 4L;
            }
            LEG.intr((byte)n);
        }
        if (jsim.stop) {
            throw new BreakException("INTERRUPTED", ip);
        }
        object = LEG.fetchInstr(ip);
        switch (((Instruction)object).code) {
            case 0: {
                LEG.Registers[((Instruction)object).reg1].value = LEG.Registers[((Instruction)object).reg2].value;
                break;
            }
            case 1: {
                LEG.Registers[((Instruction)object).reg1].value = ((Instruction)object).imm8;
                break;
            }
            case 2: {
                LEG.Registers[((Instruction)object).reg1].value = ((Instruction)object).imm32;
                break;
            }
            case 3: {
                LEG.Registers[((Instruction)object).reg1].value = Memory.readword(((Instruction)object).imm32);
                break;
            }
            case 4: {
                long l = LEG.Registers[((Instruction)object).reg2].value + (long)((Instruction)object).imm8;
                LEG.Registers[((Instruction)object).reg1].value = Memory.readword(l);
                break;
            }
            case 5: {
                Memory.writeword(((Instruction)object).imm32, LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 6: {
                Memory.writeword(LEG.Registers[((Instruction)object).reg1].value + (long)((Instruction)object).imm8, LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 7: {
                LEG.Registers[((Instruction)object).reg1].value = Memory.readbyte(((Instruction)object).imm32);
                LEG.Registers[((Instruction)object).reg1].value &= 0xFFL;
                break;
            }
            case 8: {
                LEG.Registers[((Instruction)object).reg1].value = Memory.readbyte(LEG.Registers[((Instruction)object).reg2].value + (long)((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value &= 0xFFL;
                break;
            }
            case 9: {
                Memory.writebyte(((Instruction)object).imm32, (byte)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 10: {
                Memory.writebyte(LEG.Registers[((Instruction)object).reg1].value + (long)((Instruction)object).imm8, (byte)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 16: {
                LEG.addw(LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 17: {
                LEG.addw(LEG.Registers[((Instruction)object).reg1].value, LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 18: {
                LEG.subw(LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 19: {
                LEG.subw(LEG.Registers[((Instruction)object).reg1].value, LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 20: {
                LEG.subw(LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                break;
            }
            case 21: {
                LEG.subw(LEG.Registers[((Instruction)object).reg1].value, LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 22: {
                LEG.adcw(LEG.Registers[((Instruction)object).reg1].value, LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 23: {
                LEG.sbbw(LEG.Registers[((Instruction)object).reg1].value, LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 32: {
                ip = ((Instruction)object).imm32 - 8L;
                break;
            }
            case 33: {
                ip = LEG.Registers[((Instruction)object).reg2].value - 4L;
                break;
            }
            case 34: {
                if ((flags & LEG.CF.mask) == 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 35: {
                if ((flags & LEG.CF.mask) != 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 36: {
                if ((flags & LEG.ZF.mask) == 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 37: {
                if ((flags & LEG.ZF.mask) != 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 38: {
                if ((flags & LEG.VF.mask) == 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 39: {
                if ((flags & LEG.VF.mask) != 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 40: {
                if ((flags & LEG.NF.mask) == 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 41: {
                if ((flags & LEG.NF.mask) != 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 42: {
                boolean bl;
                boolean bl2 = (flags & LEG.NF.mask) != 0L;
                boolean bl3 = bl = (flags & LEG.VF.mask) != 0L;
                if (!(bl2 ^ bl)) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 43: {
                boolean bl;
                boolean bl4 = (flags & LEG.NF.mask) != 0L;
                boolean bl5 = bl = (flags & LEG.VF.mask) != 0L;
                if ((flags & LEG.ZF.mask) == 0L && !(bl4 ^ bl)) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 44: {
                boolean bl;
                boolean bl6 = (flags & LEG.NF.mask) != 0L;
                boolean bl7 = bl = (flags & LEG.VF.mask) != 0L;
                if ((flags & LEG.ZF.mask) != 0L || bl6 ^ bl) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 46: {
                boolean bl;
                boolean bl8 = (flags & LEG.NF.mask) != 0L;
                boolean bl9 = bl = (flags & LEG.VF.mask) != 0L;
                if (bl8 ^ bl) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 47: {
                if ((flags & LEG.CF.mask + LEG.ZF.mask) != 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 31: {
                if ((flags & LEG.CF.mask + LEG.ZF.mask) == 0L) break;
                ip += (long)((Instruction)object).imm8;
                break;
            }
            case 48: {
                LEG.andw((int)LEG.Registers[((Instruction)object).reg1].value, (int)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 49: {
                LEG.orw((int)LEG.Registers[((Instruction)object).reg1].value, (int)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 50: {
                LEG.xorw((int)LEG.Registers[((Instruction)object).reg1].value, (int)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 51: {
                LEG.andw((int)LEG.Registers[((Instruction)object).reg1].value, (int)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 52: {
                LEG.notw((int)LEG.Registers[((Instruction)object).reg1].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 64: {
                LEG.shr((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 65: {
                LEG.shr((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 66: {
                LEG.shl((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 67: {
                LEG.shl((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 68: {
                LEG.sar((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 69: {
                LEG.sar((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 70: {
                LEG.rol((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 71: {
                LEG.rol((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 72: {
                LEG.ror((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 73: {
                LEG.ror((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 74: {
                LEG.rcl((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 75: {
                LEG.rcl((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 76: {
                LEG.rcr((int)LEG.Registers[((Instruction)object).reg1].value, ((Instruction)object).imm8);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 77: {
                LEG.rcr((int)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                LEG.Registers[((Instruction)object).reg1].value = res;
                break;
            }
            case 80: {
                LEG.push(LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 81: {
                LEG.Registers[((Instruction)object).reg1].value = LEG.pop();
                break;
            }
            case 82: {
                LEG.push(flags);
                break;
            }
            case 83: {
                flags = LEG.pop();
                break;
            }
            case 84: {
                long l = ((Instruction)object).imm32;
                LEG.push(ip + 8L);
                ip = l - 8L;
                break;
            }
            case 85: {
                LEG.push(ip + 4L);
                ip = LEG.Registers[((Instruction)object).reg2].value - 4L;
            }
            case 86: {
                ip = LEG.pop() - 4L;
                break;
            }
            case 87: {
                LEG.intr(((Instruction)object).imm8);
                break;
            }
            case 88: {
                if ((flags & LEG.SF.mask) == 0L) {
                    throw new BreakException("INSTRUCTION RESERVED", ip);
                }
                ip = LEG.pop();
                flags = LEG.pop();
                return;
            }
            case 96: {
                LEG.Registers[((Instruction)object).reg1].value = IO.inw(((Instruction)object).imm8 & 0xFF);
                break;
            }
            case 97: {
                LEG.Registers[((Instruction)object).reg1].value = IO.inw((byte)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 98: {
                LEG.Registers[((Instruction)object).reg1].value = IO.inb(((Instruction)object).imm8 & 0xFF) & 0xFF;
                break;
            }
            case 99: {
                LEG.Registers[((Instruction)object).reg1].value = IO.inb((byte)LEG.Registers[((Instruction)object).reg2].value) & 0xFF;
                break;
            }
            case 100: {
                IO.outw(((Instruction)object).imm8 & 0xFF, (int)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 101: {
                IO.outw((byte)LEG.Registers[((Instruction)object).reg1].value, (int)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 102: {
                IO.outb(((Instruction)object).imm8 & 0xFF, (byte)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 103: {
                IO.outb((byte)LEG.Registers[((Instruction)object).reg1].value, (byte)LEG.Registers[((Instruction)object).reg2].value);
                break;
            }
            case 112: {
                flags &= LEG.CF.mask ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 113: {
                flags |= LEG.CF.mask;
                break;
            }
            case 114: {
                if ((flags & LEG.SF.mask) == 0L) {
                    throw new BreakException("INSTRUCTION RESERVED", ip);
                }
                flags &= LEG.IF.mask ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 115: {
                if ((flags & LEG.SF.mask) == 0L) {
                    throw new BreakException("INSTRUCTION RESERVED", ip);
                }
                IO.interruptQueue.clear();
                flags |= LEG.IF.mask;
                break;
            }
            case 116: {
                throw new BreakException("HALT", ip);
            }
            case 119: {
                flags |= LEG.IF.mask;
                in_wait_instr = true;
                ip -= 4L;
                break;
            }
            case 120: {
                flags &= LEG.SF.mask ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            default: {
                throw new BreakException("NOT A INSTRUCTION", ip);
            }
        }
        ip = ((Instruction)object).imm32 == -1L ? (ip += 4L) : (ip += 8L);
    }
}

