/*
 * Decompiled with CFR 0.152.
 */
class Device {
    public String name;
    public IO.deviceType type;
    public SegDisp display;
    public myButton button;
    public mySlider slider;
    public Leds leds;
    public MixedLeds mixedleds;
    public SysTickRegister systick;
    public kRegister keyboard;
    public myTimer timer;
    public myLogger logger;
    public myDummy dummy;

    Device(String string, IO.deviceType deviceType2, myButton myButton2) {
        this.name = string;
        this.type = deviceType2;
        this.button = myButton2;
    }

    Device(String string, myLogger myLogger2) {
        this.name = string;
        this.type = IO.deviceType.LOGGER;
        this.logger = myLogger2;
    }

    Device(String string, myDummy myDummy2) {
        this.name = string;
        this.type = IO.deviceType.DUMMY;
        this.dummy = myDummy2;
    }

    Device(String string, kRegister kRegister2) {
        this.name = string;
        this.type = IO.deviceType.KEYBOARD;
        this.keyboard = kRegister2;
    }

    Device(String string, Leds leds) {
        this.name = string;
        this.type = IO.deviceType.LEDS;
        this.leds = leds;
    }

    Device(String string, MixedLeds mixedLeds) {
        this.name = string;
        this.type = IO.deviceType.MIXEDLEDS;
        this.mixedleds = mixedLeds;
    }

    Device(String string, SegDisp segDisp) {
        this.name = string;
        this.type = IO.deviceType.DISPLAY;
        this.display = segDisp;
    }

    Device(String string, SysTickRegister sysTickRegister) {
        this.name = string;
        this.type = IO.deviceType.SYSTICK;
        this.systick = sysTickRegister;
    }

    Device(String string, mySlider mySlider2) {
        this.name = string;
        this.type = IO.deviceType.SLIDER;
        this.slider = mySlider2;
    }

    Device(String string, myTimer myTimer2) {
        this.name = string;
        this.type = IO.deviceType.TIMER;
        this.timer = myTimer2;
    }

    public void setValue(int n) {
        switch (this.type) {
            case DISPLAY: {
                this.display.setValue(n);
                break;
            }
            case LEDS: {
                this.leds.setValue(n);
                break;
            }
            case MIXEDLEDS: {
                this.mixedleds.setValue(n);
                break;
            }
            case TIMER: {
                myTimer.setValue(n);
                break;
            }
            case TBUTTON: 
            case JBUTTON: {
                this.button.setValue(n);
                break;
            }
            case LOGGER: {
                this.logger.setValue(n);
                break;
            }
            case DUMMY: {
                this.dummy.setValue(n);
                break;
            }
        }
    }

    public int getValue() {
        switch (this.type) {
            case TBUTTON: 
            case JBUTTON: {
                return this.button.getValue();
            }
            case KEYBOARD: {
                return this.keyboard.getValue();
            }
            case SLIDER: {
                return this.slider.getValue();
            }
            case DUMMY: {
                return this.dummy.getValue();
            }
        }
        return 0;
    }
}

