/*
    Um deque (double-ended queue) é uma estrutura de dados com as  operações: insere_inicio, insere_fim, remove_inicio, remove_fim.

    Implemente um \emph{deque} utilizando listas ligadas.
*/

typedef struct no {
    int dado;
    struct no *prox, *ant;
} No;

typedef No * p_no;

typedef struct {
    p_no inicio, fim;
} Deque;

typedef Deque * p_deque;

p_deque cria_deque() {
    p_deque d = malloc(sizeof(Deque));
    d->inicio = d->fim = NULL;
    return d;
}

void insere_inicio(p_deque d, int dado) {
    p_no novo = malloc(sizeof(No));
    novo->dado = dado;
    novo->prox = d->inicio;
    novo->ant = NULL;
    if (d->inicio != NULL)
        d->inicio->ant = novo;
    else
        d->fim = novo;
    d->inicio = novo;
}

void insere_fim(p_deque d, int dado) {
    p_no novo = malloc(sizeof(No));
    novo->dado = dado;
    novo->prox = NULL;
    novo->ant = d->fim;
    if (d->fim != NULL)
        d->fim->prox = novo;
    else
        d->inicio = novo;
    d->fim = novo;
}

int remove_inicio(p_deque d) {
    p_no aux = d->inicio;
    int dado = aux->dado;
    d->inicio = d->inicio->prox;
    if (d->inicio != NULL)
        d->inicio->ant = NULL;
    else
        d->fim = NULL;
    free(aux);
    return dado;
}

int remove_fim(p_deque d) {
    p_no aux = d->fim;
    int dado = aux->dado;
    d->fim = d->fim->ant;
    if (d->fim != NULL)
        d->fim->prox = NULL;
    else
        d->inicio = NULL;
    free(aux);
    return dado;
}