# Enunciado:

# Faça uma função que dadas strings s e t, retorna True se s é prefixo de t e
# False caso contrário.

# Faça uma função que dadas strings s e t, retorna True se s é substring de t e
# False caso contrário.

# Faça uma função que dada uma string s e um separador sep, retorna uma lista
# com as palavras de s separadas por sep.

# Versão com slices
def prefixo_v1(s: str, t: str) -> bool:
    # se s for maior que t, o slice vai retornar simplesmente t (não gera erro)
    return t[:len(s)] == s


# Versão sem slices
def prefixo(s: str, t: str) -> bool:
    # se s for maior que t, então s não pode ser prefixo de t
    if len(s) > len(t):
        return False
    for i in range(len(s)):
        # se algum caractere for diferente, então s não é prefixo de t
        if s[i] != t[i]:
            return False
    return True


# Versão com dois whiles
def substring(texto: str, padrao: str) -> bool:
    # j é a posição do texto onde tentamos encaixar o padrão
    # j vai de 0 até len(texto) - len(padrao), pois se j for maior que isso,
    # então não temos espaço para encaixar o padrão
    for j in range(len(texto) - len(padrao) + 1):
        # i é a posição do padrão que estamos tentando encaixar
        i = 0
        while i < len(padrao):
            # se não encaixou, terminamos o while e
            # i será diferente de len(padrao)
            if padrao[i] != texto[j + i]:
                break
            i += 1
        # se i é igual ao len(padrao), então encaixou
        if i == len(padrao):
            return True
    # se nunca conseguimos encaixar o padrão, então não é substring
    return False


# Segunda versão - mudamos a função prefixo para começar de um ponto do texto
def prefixo_v3(s: str, t: str, pos: int = 0) -> bool:
    # se s for maior do que o que sobra de t, então s não pode ser prefixo de t
    if len(s) > len(t) - pos:
        return False
    for i in range(len(s)):
        # se algum caractere for diferente, então s não é prefixo de t
        if s[i] != t[pos + i]:
            return False
    return True


# E agora usamos a nova função prefixo_v3 para fazer a substring
def substring_v2(texto: str, padrao: str) -> bool:
    for j in range(len(texto) - len(padrao) + 1):
        if prefixo_v3(padrao, texto, j):
            return True
    return False


# Para separar, podemos usar a função prefixo_v3
def separa(string: str, sep: str) -> list[str]:
    palavras = []
    ultima_posicao = 0
    for i in range(len(string)):
        if prefixo_v3(sep, string, i):
            palavras.append(string[ultima_posicao:i])
            ultima_posicao = i + len(sep)
    palavras.append(string[ultima_posicao:])
    return palavras


print(prefixo("ana", "anamaria"))
print(prefixo("anamaria", "ana"))
print(separa("ana-maria-fernanda", "-"))
print(separa("ana-maria-", "-"))
print(separa("-ana-maria-", "-"))
