# Enunciado:
# Escreva uma função que, dada uma lista, uma posição e um elemento,
# insire o elemento na posição dada da lista (mantendo os dados existentes).

# Primeira versão
def insere_v1(lista: list, pos: int, x):
    # inserimos x no final da lista
    lista.append(x)
    i = len(lista) - 1
    # enquanto x não está na posição correta
    while (i > pos):
        # troca x com o elemento anterior
        aux = lista[i]
        lista[i] = lista[i - 1]
        lista[i - 1] = aux
        i -= 1


# Segunda versão usando for ao invés de while
def insere_v2(lista: list, pos: int, x):
    lista.append(x)
    for i in range(len(lista) - 1, pos, -1):
        aux = lista[i]
        lista[i] = lista[i - 1]
        lista[i - 1] = aux


# Terceira versão
def insere_v3(lista: list, pos: int, x):
    # adiciona um elemento nulo no final da lista para criar espaço para x
    lista.append(None)
    for i in range(len(lista) - 1, pos, -1):
        # ao invés de ir trocando, vamos deslocando os elementos para a direita
        lista[i] = lista[i - 1]
    # agora que temos espaço, podemos inserir x
    lista[pos] = x


# Aqui usamos o slice para inserir o x
def insere_v4(lista: list, pos: int, x):
    lista[pos:pos] = [x]


lista = [1, 3, 7]
insere_v1(lista, 0, 42)
print(lista)  # [42, 1, 3, 7]
