# Enunciado:
# Faça uma função que dada uma lista, retorna uma nova lista com os elementos
# da lista original invertidos.
# Faça uma versão que altera a lista original (in place).

def inverte(lista: list) -> list:
    nova = []
    for i in range(len(lista) - 1, -1, -1):
        nova.append(lista[i])
    return nova


# Essa versão gasta tempo e memória desnecessariamente
def inverte_in_place_v1(lista: list) -> None:
    invertida = inverte(lista)
    for i in range(len(lista)):
        lista[i] = invertida[i]


def inverte_in_place(lista: list) -> None:
    n = len(lista)
    for i in range(n // 2):
        aux = lista[i]
        lista[i] = lista[n - i - 1]
        lista[n - i - 1] = aux


lista1 = [1, 2, 3]
lista1 = lista1[::-1]

lista2 = inverte(lista1)
print(lista2)  # [3, 2, 1]

inverte_in_place(lista1)
print(lista1)  # [3, 2, 1]
