/*
 * Exemplo de uso de pipes: cmd1 | cmd2 args2
 *
 * Nesta verso simplificada, cmd1 no pode
 * receber argumentos. Podem ser testados comandos
 * como: /usr/bin/ls | /usr/bin/grep pipe
 */

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
   
int  main (int argc, char** argv) {
  int mypipe[2];
  
  if (argc < 3) {
    printf("Uso: %s <cmd1> <cmd2> <args2>", argv[0]);
    return 0;
  }
  
  pipe (mypipe);   /* Cria o pipe mypipe. 
		      mypipe[0] - leitura 
		      mypipe[1] - escrita	 		 
		   */
     
  if (fork() != 0)
    if (fork() != 0) {/* Pai (shell) */
      close (mypipe[0]);  /* Fecha o pipe */
      close (mypipe[1]); 
      wait(NULL);         /* Aguarda o trmino */
      wait(NULL);         /* dos processos     */ 
    } 
    else { /* Processo que executa cmd2 */ 
      close (mypipe[1]);  /* Apenas l do pipe */ 
      dup2(mypipe[0], 0); /* Modifica entrada padro */		
      execve (argv[2], &argv[2],0);
      printf("Erro em cmd2\n" );
   }
  else { /* Processo que executa cmd1 */ 
    close (mypipe[0]);  /* Apenas escreve no pipe */
    dup2(mypipe[1], 1); /* Modifica sada padro */
    argv[2] = NULL; /* cmd2 no  necessrio */
    execve(argv[1], &argv[1], 0);
    printf("Erro em cmd1\n");
  }
  return 0;
}
