/*
 * Leitores e escritores utilizando rwlocks.
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define NL 10
#define NE 3
volatile int bd = -1; /* Banco de dados */
pthread_rwlock_t rwlock;

void *leitor(void* v) {
  int id = (int) v;

  pthread_rwlock_rdlock(&rwlock);
  sleep(1);
  printf("Leitor %d leu o valor %d \n", id, bd);
  pthread_rwlock_unlock(&rwlock);
  
  return NULL;
}

void *escritor(void *v) {
  int id = (int) v;
  
  pthread_rwlock_wrlock(&rwlock);
  bd = id;
  sleep(1);
  printf("Escritor %d escreveu o valor %d \n", id, bd);
  pthread_rwlock_unlock(&rwlock);

  return NULL;
}

#define N 300
int main() {
  pthread_t thr[N];
  int i = 0, l = 0, e = 0;
  
  pthread_rwlock_init(&rwlock, NULL);

  srandom(time(NULL));
  for (i = 0; i < N; i++) {
    if (random() % 2) 
      pthread_create(&thr[i], NULL, leitor, (void*) l++);
    else
      pthread_create(&thr[i], NULL, escritor, (void*) e++);
  }

  pthread_exit(NULL);
}


