/*
 * Leitores e escritores utilizando locks e variáveis
 * de condição. 
 * Como implementar:
 *   - prioridade para leitores (possível starvation de escritores)
 *   - prioridade para escritores (possível starvation de leitores)
 *   - ausência de starvation
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

volatile int bd = -1; /* Banco de dados */

/* Sugestões de variáveis */
volatile int nl = 0;
volatile int ne = 0;
volatile int we = 0, re = 0;
volatile int ult = 0; /* por exemplo, leitor =0, escritor = 1*/

/* Para execução sem verificação de erros */
pthread_mutex_t lock_cont = PTHREAD_MUTEX_INITIALIZER; 

pthread_cond_t cond_escr = PTHREAD_COND_INITIALIZER;
pthread_cond_t cond_leit = PTHREAD_COND_INITIALIZER;

void *leitor(void* v) {
  int id = (int) v;
  int n_vezes;
  
  pthread_mutex_lock(&lock_cont);
  re++;
  n_vezes = 0;
  while (ne > 0) {
     pthread_cond_wait(&cond_leit, &lock_cont);
     n_vezes++;
  }
  nl++;
  re--;
  pthread_mutex_unlock(&lock_cont);
  sleep(1);
  printf("Leitor %d leu o valor %d \n", id, bd);
  pthread_mutex_lock(&lock_cont);
  nl--;
  if (nl == 0) 
    pthread_cond_signal(&cond_escr);
  pthread_mutex_unlock(&lock_cont);
  return NULL;
}

void *escritor(void *v) {
  int id = (int) v;

  pthread_mutex_lock(&lock_cont);
  we++;
  while (nl > 0 || ne > 0) 
    pthread_cond_wait(&cond_escr, &lock_cont);
  ne++;
  we--;
  pthread_mutex_unlock(&lock_cont);
  bd = id;
  sleep(1);
  printf("Escritor %d escreveu o valor %d \n", id, bd);
  pthread_mutex_lock(&lock_cont);
  ne--;
  pthread_cond_broadcast(&cond_leit);  
  pthread_cond_signal(&cond_escr);
  pthread_mutex_unlock(&lock_cont);
  return NULL;
}

#define N 300
int main() {
  pthread_t thr[N];
  int i = 0, l = 0, e = 0;

  srandom(time(NULL));
  for (i = 0; i < N; i++) {
    if (random() % 2) 
      pthread_create(&thr[i], NULL, leitor, (void*) l++);
    else
      pthread_create(&thr[i], NULL, escritor, (void*) e++);
  }

  pthread_exit(NULL);
}


