/*
 * Problema do barbeiro dorminhoco com vários barbeiros.
 * Desenvolva a parte do painel para gerar uma saída como esta:

Barbeiro 0 escreveu no painel.
Cliente 2 sentou na cadeira do barbeiro 0.
Barbeiro 1 escreveu no painel.
Cliente 7 sentou na cadeira do barbeiro 1.
Barbeiro 1 escreveu no painel.
Cliente 8 sentou na cadeira do barbeiro 1.
Barbeiro 0 escreveu no painel.
Cliente 0 sentou na cadeira do barbeiro 0.
Barbeiro 0 escreveu no painel.

 */

#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define N_CLIENTES 10
#define N_BARBEIROS 2
#define N_CADEIRAS 5

volatile int painel = -1;

void* f_barbeiro(void *v) {
  int id = *(int*)v;

  while(1) {
    painel = id;
    printf("Barbeiro %d escreveu no painel.\n", id);
    sleep(random()%3);
  }
  return NULL;
}

void* f_cliente(void* v) {
  int id = *(int*) v;
  int minha_cadeira;

  sleep(random()%3);
  minha_cadeira = painel;
  printf("Cliente %d sentou na cadeira do barbeiro %d.\n", id,
	   minha_cadeira);
  return NULL;
}

int main() {
  pthread_t thr_clientes[N_CLIENTES], thr_barbeiros[N_BARBEIROS];
  int i, id_cl[N_CLIENTES], id_bar[N_BARBEIROS];

  for (i = 0; i < N_CLIENTES; i++) {
    id_cl[i] = i;
    pthread_create(&thr_clientes[i], NULL, f_cliente, (void*) &id_cl[i]);
  }

  for (i = 0; i < N_BARBEIROS; i++) {
    id_bar[i] = i;
    pthread_create(&thr_barbeiros[i], NULL, f_barbeiro, (void*) &id_bar[i]);
  }
  
  for (i = 0; i < N_CLIENTES; i++) 
    pthread_join(thr_clientes[i], NULL);

  /* Barbeiros são assassinados */
  
  return 0;
}
