/*
 * Vetor de interesse para N threads.
 */
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define N 5

volatile int s = 0; /* Variável compartilhada */
volatile int interesse[N] = {0, 0, 0, 0, 0}; /* Indica quais threads estão
                                       interessadas em entrar na região crítica */

int existe_outra_interessada(int i) {
  int k;
  for (k = 0; k < N; k++) 
    if (k != i && interesse[k])
      return 1;
  return 0;
}

void* f_thread(void *v) {
  int i = *(int*)v;
  int k;

  for (k = 0; k < 5; k++) {
    interesse[i] = 1; /* Marca que esta thread está interessada */
    while (existe_outra_interessada(i));
  
    s = i;
    printf("Thread %d, s = %d.\n", i, s); 
  
    interesse[i] = 0;  /* Marca que saiu da região crítica */
  }
  return NULL;
}

int main() {

  pthread_t thr[N];
  int id[N], k;

  for (k = 0; k < N; k++) {
    id[k] = k;
    pthread_create(&thr[k], NULL, f_thread, &id[k]);
  }

  for (k = 0; k < N; k++) 
    pthread_join(thr[k], NULL); 

  return 0;
}

