/*
 * Controle da regio crtica por meio de um 
 * vetor de interesse. 
 */
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

volatile int s = 0; /* Varivel compartilhada */
volatile int interesse[2] = {0, 0}; /* Indica quais threads esto
                                       interessadas em entrar na regio crtica */

void* f_thread_0(void *v) {
  int i;

  for (i = 0; i < 10; i++) {
    interesse[0] = 1; /* Marca que esta thread est interessada */
    while (interesse[1]) {
      interesse[0] = 0;
      sleep(1);
      interesse[0] = 1;
    }
  
    s = 0;
    printf("Thread 0, s = %d.\n", s); 
  
    interesse[0] = 0;  /* Marca que saiu da regio crtica */
  }
  return NULL;
}

void* f_thread_1(void *v) {
  int i;

  for (i = 0; i < 10; i++) {
    interesse[1] = 1; /* Marca que esta thread est interessada */
    while (interesse[0]) {
      interesse[1] = 0;
      sleep(1);
      interesse[1] = 1;
    }
  
    s = 1;
    printf("Thread 1, s = %d.\n", s); 
  

    interesse[1] = 0;  /* Marca que saiu da regio crtica */
  }
  return NULL;
}

int main() {

  pthread_t thr0, thr1;

  pthread_create(&thr0, NULL, f_thread_0, NULL);
  pthread_create(&thr1, NULL, f_thread_1, NULL);

  pthread_join(thr0, NULL); 
  pthread_join(thr1, NULL);
  
  return 0;
}

