/*
 * Thread "gerente" e N threads disputando
 * a região crítica. Será que funciona?
 */
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define N 10

volatile int s = 0;   /* Variável compartilhada */

volatile int rc = -1; /* Indica de qual thread é a vez de 
                         entrar na região crítica */
volatile int interesse[N]; /* Indica que uma thread está
                              interessada em entra na RC */

void* f_gerente(void *v) {
  int i;

  while (1) 
    for (i = 0; i < N; i++) 
      if (interesse[i]) {
	rc = i; /* Passa a vez para a thread i */
	while (interesse[i]);
      }
}

void* f_thread(void *v) {
  int thr_id = *(int*)v;
  int i;

  for (i = 0; i < 5; i++) {
    interesse[thr_id] = 1;
    while (rc != thr_id); /* Espera ser a vez desta thread */
    printf("Início Thread %d.\n", thr_id); 
    s = thr_id;
    printf("Thread %d, s = %d.\n", thr_id, s); 
    printf("Fim Thread %d.\n", thr_id); 
    interesse[thr_id] = 0;
    sleep(1);
  }
  return NULL;
}

int main() {

  pthread_t thr[N], thr_gerente;
  int id[N], i;

  pthread_create(&thr_gerente, NULL, f_gerente, NULL);

  for (i = 0; i < N; i++) {
    id[i] = i;
    pthread_create(&thr[i], NULL, f_thread, &id[i]);
  }

  for (i = 0; i < N; i++) 
    pthread_join(thr[i], NULL); 

  /* Não espera pela thread gerente. */

  return 0;
}

