/*
 * Controle da região crítica por alternância simples.
 * Código para N threads.
 */
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define N 10

volatile int s = 0; /* Variável compartilhada */
volatile int vez = 0; /* Indica de qual thread é a vez de 
                         entrar na região crítica */

void* f_thread(void *v) {
  int thr_id = *(int*)v;
  int i;

  for (i = 0; i < 5; i++) {
    while (vez != thr_id); /* Espera ser a vez desta thread */
  
    s = thr_id;
    printf("Thread %d, s = %d.\n", thr_id, s); 
  
    vez = (thr_id + 1)%N; /* Passa a vez para a outra thread */
  }
  return NULL;
}

int main() {

  pthread_t thr[N];
  int id[N], i;

  for (i = 0; i < N; i++) {
    id[i] = i;
    pthread_create(&thr[i], NULL, f_thread, &id[i]);
  }

  for (i = 0; i < N; i++) 
    pthread_join(thr[i], NULL); 

  return 0;
}

