/*
 * Como implementar barreiras de forma eficiente?
 * Quarta tentativa
 */

#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define N 10

sem_t sem_mutex, sem_barreira;

volatile int c;

void *f_thread(void* v) {
  int id = (int) v;
  int i, local_c;

  for (i = 0; i < 2; i++) {
    sleep(random() % 3);
    printf("Thread %d atingiu a barreira.\n", id);
    sem_wait(&sem_mutex);
    c++;
    if (c < N) {
       sem_post(&sem_mutex);
       sem_wait(&sem_barreira);
    }
    local_c = __sync_sub_and_fetch (&c, 1);
    if (local_c > 0) sem_post(&sem_barreira);
    else sem_post(&sem_mutex);

    printf("Thread %d passou pela barreira.\n", id);
    sleep(4);
  }
  return NULL;
}

int main() {
  pthread_t thr[2*N];
  int i = 0;

  srandom(time(NULL));
  sem_init(&sem_barreira, 0, 0);
  sem_init(&sem_mutex, 0, 1);
  for (i = 0; i < 2*N; i++) 
    pthread_create(&thr[i], NULL, f_thread, (void*) i);

  pthread_exit(NULL);
}


