% Autor: Leonardo R. Olivi

clear; clc; close all;

% Tempo de amostragem
Dt = 0.01;

% Matriz A
A = [1 Dt
     0 1];
 
% Matriz B
B = [Dt^2/2
     Dt];
 
% Controle (aceleracao)
u = 5;

% Estado inicial
x = [0
     0];

% Matriz de covariancia do sistema 'real'
dps = 0.01; dpv = 0.01;
R = [dps^2 0
     0   dpv^2];
 
% Sensor:
dpy = 1;
Q = dpy^2;

C = [1 0];

% modelo matematico (valor inicial)
mi = [10
      10];
Sigma = R;

% Processo
X = [];
Z = [];
M = [];
T = [];
Y = [];

for t = 0:Dt:8

    T = [T t];
    
    % Evolui o sistema 'real'
    x = A * x + B * u + sqrt(diag(R)) .* randn(2,1);
    X = [X x(1)];
    
    % Observa o sistema com um sensor 'real'
    z = C * x + Q * randn;
    Z = [Z z];
    
    % ======= Fase de Predicao =======
    
    % Estado dado pelo modelo do sistema
    mi = A * mi + B * u;
    
    % Leitura esperada do sensor
    zs = C * mi;
    M = [M zs];
    
    % Evolui o modelo de covariancias do modelo
    % Quanto mais o tempo passa, se o modelo nao for corrigido, maior eh a
    % distancia entre o modelo e o sistema 'real', portanto, a covariancia
    % do erro aumenta
    Sigma = A * Sigma * A' + R;

    % ======= Fase de Atualizacao =======
    
    % Inovacao: diferenca entre a leitura do sensor real e a leitura esperada
    inova = z - zs;

    % Ganho de Kalman
    S = C * Sigma * C' + Q;
    K = Sigma * C' * inv(S);
    
    % Atualiza o estado do modelo com a leitura do sensor
    mi = mi + K * inova;
    
    % Atualiza a covariancia do modelo
    Sigma = (eye(2) - K * C) * Sigma;
end
	
    % Plot
    plot(10*T , Z , 'g' , 10*T , X , 'r' , 10*T , M , 'k')
    axis([0 100 -10 100], "square")
    title(['Erro = ' num2str(inova)])
    axis equal
    drawnow
    hold on
end 
