unit IBLicense;

interface
uses
  Windows, Forms, Dialogs, Messages, SysUtils, Classes;
const
  _IB_LICENSE_API_               = 'iblicense.dll';
  _IB_LICENSE_FILE_              = 'ib_license.dat';
  
  LICENSE_ADD                    = 'isc_license_add';
  LICENSE_CHECK                  = 'isc_license_check';
  LICENSE_DISPLAY                = 'isc_license_display';
  LICENSE_MSG                    = 'isc_license_get_msg';
  LICENSE_REMOVE                 = 'isc_license_remove';

  isc_license_msg_prompt         = 17;
  isc_license_msg_version        = 18;
  isc_license_msg_opspec         = 19;
  isc_license_msg_noopspec       = 20;
  isc_license_msg_invsw          = 21;
  isc_license_msg_invswsw        = 22;
  isc_license_msg_invswop        = 23;
  isc_license_msg_ambsw          = 24;
  isc_license_msg_invpar         = 25;
  isc_license_msg_swnopar        = 26;
  isc_license_msg_reqpar         = 27;
  isc_license_msg_syntax         = 28;
  isc_license_msg_restart        = 29;
  isc_license_msg_dupid	         = 30;
  isc_license_msg_invkey         = 31;
  isc_license_msg_notremoved     = 32;
  isc_license_msg_writefailed    = 33;
  isc_license_msg_convertfailed  = 34;
  isc_license_msg_unk	         = 35;
  isc_license_success            = isc_license_msg_restart;

  ISC_LICENSE_MAX_MESSAGE_LEN    = 256;
  ISC_LICENSE_MAX_LICENSE_LEN    = 1024;

  LicenseAPINotFound =
     'Unable to load the license verification library.'+#10#13+#10#13+
     'Please ensure that you are installing with the correct'+#10#13+
     'media'+#10#13+#10#13+
     'Click Ok to exit setup.';

type
  Tisc_license_add = function (cert_id : PChar; cert_key : PChar) : Integer; stdcall;

  Tisc_license_check = function(cert_id : PChar; cert_key : PChar) : Integer; stdcall;

  Tisc_license_remove = function (cert_key :PChar) : Integer; stdcall;

  Tisc_license_display = function (buf : PChar; buf_len : Word) : Word; stdcall;
  Tisc_license_get_msg = function (msg_no : Smallint; msg : PChar; msg_len : Word):
                                    Word; stdcall;

  function IscLicenseAdd(LibPath, cert_id, cert_key : string) : Integer;
  function IscLicenseCheck(LibPath : string; cert_id, cert_key : string) : Integer;
  function IscLicenseRemove(LibPath, cert_key : string) : Integer;
  function IscLicenseDisplay(LibPath: string) : string;
  function IscLicenseGetMessage (LibPath : string; msg_no : Smallint): string;

implementation

function IscLicenseAdd(LibPath, cert_id, cert_key : string) : Integer;
var
  LibHandle: THandle;
  Pisc_license_add : Tisc_license_add;
begin
  LibHandle := LoadLibrary(PChar(LibPath));
  if LibHandle = 0 then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  @Pisc_license_add := GetProcAddress(LibHandle,LICENSE_ADD);

  if @Pisc_license_add = nil then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  Result := Pisc_license_add(PChar(cert_id), PChar(cert_key));
  FreeLibrary(LibHandle);
end;

function IscLicenseCheck(LibPath : string; cert_id, cert_key : string) : Integer;
var
  LibHandle: THandle;
  Pisc_license_check : Tisc_license_check;
begin
  LibHandle := LoadLibrary(PChar(LibPath));
  if LibHandle = 0 then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  @Pisc_license_check := GetProcAddress(LibHandle,LICENSE_CHECK);

  if @Pisc_license_check = nil then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  Result := Pisc_license_check(PChar(cert_id), PChar(cert_key));
  FreeLibrary(LibHandle);
end;

function IscLicenseRemove(LibPath, cert_key : string) : Integer;
var
  LibHandle             : THandle;
  Pisc_license_remove  : Tisc_license_remove;
begin
  LibHandle := LoadLibrary(PChar(LibPath));
  if LibHandle = 0 then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  @Pisc_license_remove := GetProcAddress(LibHandle,LICENSE_REMOVE);

  if @Pisc_license_remove = nil then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  Result := Pisc_license_remove(PChar(cert_key));
  FreeLibrary(LibHandle);
end;

function IscLicenseDisplay(LibPath : string) : string;
var
  LibHandle            : THandle;
  License              : string;
  Pisc_license_display : Tisc_license_display;
  RetVal               : Word;
begin
  LibHandle := LoadLibrary(PChar(LibPath));
  if LibHandle = 0 then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  @Pisc_license_display := GetProcAddress(LibHandle,LICENSE_DISPLAY);

  if @Pisc_license_display = nil then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  SetLength(License, ISC_LICENSE_MAX_LICENSE_LEN);
  RetVal := Pisc_license_display(PChar(License), ISC_LICENSE_MAX_LICENSE_LEN);
  if RetVal <> 0 then
    Result := ''
  else begin
    SetLength(License, StrLen(PChar(License)));
    Result := License;
  end;
  FreeLibrary(LibHandle);
end;

function IscLicenseGetMessage(LibPath : string; msg_no : Smallint): string;
var
  LibHandle            : THandle;
  IscMessage           : string;
  RetVal               : Word;
  Pisc_license_get_msg : Tisc_license_get_msg;
begin
  LibHandle := LoadLibrary(PChar(LibPath));
  if LibHandle = 0 then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

  @Pisc_license_get_msg := GetProcAddress(LibHandle,LICENSE_MSG);

  if @Pisc_license_get_msg = nil then
  begin
    MessageDlg(LicenseAPINotFound,mtError,[mbOK],0);
    Application.Terminate;
  end;

 SetLength(IscMessage, ISC_LICENSE_MAX_MESSAGE_LEN);
 RetVal := Pisc_license_get_msg(msg_no, PChar(IscMessage), ISC_LICENSE_MAX_MESSAGE_LEN);

 if RetVal <> 0 then
   Result := ''
 else begin
   SetLength(IscMessage, StrLen(PChar(IscMessage)));
   Result := IscMessage;
 end;

 FreeLibrary(LibHandle);
end;

end.
