/*
 * iblicense.h
 *
 * copyright (c) 1999 by Inprise Corporation
 */


#ifndef _IBLICENSE_H_
#define _IBLICENSE_H_


/******************************************************************/
/* Define type, export and other stuff based on c/c++ and Windows */
/******************************************************************/

#ifndef ISC_EXPORT

#if (defined(_MSC_VER) && defined(WIN32)) || \
    (defined(__BORLANDC__) && (defined(__WIN32__) || defined(__OS2__)))
#define  ISC_FAR
#define  ISC_EXPORT         __stdcall
#define  ISC_EXPORT_VARARG  __cdecl
#else                   /* Not Windows/NT */
#if (defined(__IBMC__) && defined(__OS2__))
#define  ISC_FAR
#define  ISC_EXPORT         System
#define  ISC_EXPORT_VARARG  ISC_EXPORT
#else                   /* not IBM C Set++ for OS/2 */
#if ( defined( _Windows) || defined( _WINDOWS))
#define  ISC_FAR        __far
#define  ISC_EXPORT     ISC_FAR __cdecl __loadds __export
#define  ISC_EXPORT_VARARG  ISC_EXPORT
#else                   /* Not Windows/NT, OS/2 or Windows */
#define  ISC_FAR
#define  ISC_EXPORT
#define  ISC_EXPORT_VARARG
#endif                  /* Windows and Not Windows/NT or OS/2 */
#endif                  /* IBM C Set++ for OS/2 */
#endif                  /* Windows/NT */

#endif /* ISC_EXPORT */

#define   _IB_LICENSE_FILE_                 "ib_license.dat"

#define   ISC_LICENSE_ADD                   "isc_license_add"
#define   ISC_LICENSE_CHECK                 "isc_license_check"
#define   ISC_LICENSE_DISPLAY               "isc_license_display"
#define   ISC_LICENSE_MSG                   "isc_license_get_msg"
#define   ISC_LICENSE_REMOVE                "isc_license_remove"

#define   isc_license_msg_prompt            17
#define   isc_license_msg_version           18
#define   isc_license_msg_opspec            19
#define   isc_license_msg_noopspec          20
#define   isc_license_msg_invsw             21
#define   isc_license_msg_invswsw           22
#define   isc_license_msg_invswop           23
#define   isc_license_msg_ambsw             24
#define   isc_license_msg_invpar            25
#define   isc_license_msg_swnopar           26
#define   isc_license_msg_reqpar            27
#define   isc_license_msg_syntax            28
#define   isc_license_msg_restart           29
#define   isc_license_msg_dupid	            30
#define   isc_license_msg_invkey            31
#define   isc_license_msg_notremoved        32
#define   isc_license_msg_writefailed       33
#define   isc_license_msg_convertfailed     34
#define   isc_license_msg_unk	            35
#define   isc_license_success               isc_license_msg_restart

#define   ISC_LICENSE_MAX_MESSAGE_LEN       256
#define   ISC_LICENSE_MAX_LICENSE_LEN       1024


typedef int (ISC_EXPORT *Pisc_license_add)(char*, char*);

typedef int (ISC_EXPORT *Pisc_license_check)(char*, char*);

typedef int (ISC_EXPORT *Pisc_license_remove)(char*);

typedef unsigned short (ISC_EXPORT *Pisc_license_display)(char*, unsigned short);

typedef unsigned short (ISC_EXPORT *Pisc_license_get_msg)(short, char*, unsigned short);


#endif /* _IBLICENSE_H_ */