/*
 *  Program type:   Embedded Static SQL
 *
 *  Description:
 *		This program demonstrates a singleton select.
 *		A full name and phone number are displayed for
 *		the CEO of the company.
 */

#include "example.h"
#include <stdlib.h>
#include <stdio.h>

#define	FIRSTLEN	15
#define	LASTLEN		20
#define EXTLEN		4
#define DEPTNO		3
#define PHONELEN	20

EXEC SQL
	BEGIN DECLARE SECTION;
EXEC SQL
	END DECLARE SECTION;


int main PROTO((void))
{
	char first[FIRSTLEN + 1];
	char last[LASTLEN + 1];
	char ext[EXTLEN + 1];
	char phone[PHONELEN + 1];
	char dept[DEPTNO + 1];

	/*
	 *  Assume there's only one CEO.
	 *  Select the name and phone extension.
	 */
	EXEC SQL
		SELECT first_name, last_name, phone_ext, dept_no
		INTO :first, :last, :ext, :dept
		FROM employee
		WHERE job_code = 'CEO';

	/* Check the SQLCODE to make sure only 1 row was selected. */
	if (SQLCODE)
	{
		isc_print_sqlerror((short)SQLCODE, gds__status);
		exit(1);
	}

	/*
	 *  Also, select the department phone number.
	 */

	EXEC SQL
		SELECT phone_no
		INTO :phone
		FROM department
		WHERE dept_no = :dept;

	if (SQLCODE)
	{
		isc_print_sqlerror((short)SQLCODE, gds__status);
		exit(1);
	}

	printf("President:  %s %s\t\t", first, last);
	printf("Phone #:  %s  x%s\n", phone, ext);

	EXEC SQL
		COMMIT RELEASE;
exit(0);
}

