@echo off

echo.
echo Running PC Magazine database benchmark setup...
echo   Oracle8i version
echo.
echo Current date and time:
date /t
time /t

:START
echo.
echo.
echo '===================================================
echo Set up file location variables and initial directory
echo '===================================================
echo.
echo.

echo 1. Set environment variables
set PCM_BENCHMARK_HOME_DRIVE=C:
set PCM_BENCHMARK_HOME_DIRECTORY=C:\OracleBench
set ORACLE_LOG_DRIVE=E:
set ORACLE_DATA_DRIVE=F:
if not exist "%PCM_BENCHMARK_HOME_DIRECTORY%\dbsetup_orcl.bat" goto FILES_MISSING_ERROR
%PCM_BENCHMARK_HOME_DRIVE%
cd %PCM_BENCHMARK_HOME_DIRECTORY%

rem Jump-off point
goto CONFIG_DB

:CONFIG_DB
echo.
echo.
echo '=========================================
echo B. Configure Database Server
echo '=========================================
echo.
echo.

echo Press any key to configure the benchmark database. Make sure you have edited
echo this file to enter valid directory variables for your system first!
echo.
pause
echo.

cd "B - Configure Database Server"

echo Stopping database (ignore error if the service doesn't exist)
oradim -shutdown -sid pcmag
echo Starting Oracle TNS Listener (ignore error if the service is already started)
net start OracleOraHome81TNSListener
echo Create Oracle directories for 'PCMAG' database
if not exist c:\oracle\admin\pcmag\nul mkdir c:\oracle\admin\pcmag
if not exist c:\oracle\admin\pcmag\pfile\nul mkdir c:\oracle\admin\pcmag\pfile

echo 1. Copy initpcmag.ora and init.ora files to their proper locations
copy initpcmag.ora c:\oracle\ora81\database
copy init.ora C:\oracle\Admin\pcmag\pfile\init.ora

echo 2. Create 'PCMAG' database password file
orapwd file=C:\Oracle\Ora81\database\PWDpcmag.ora password=oracle entries=10

echo 3. Create 'PCMAG' instance (oradim automatically starts it)
oradim -new -sid PCMAG -intpwd oracle -startmode auto -pfile c:\oracle\ora81\database\initpcmag.ora
echo.
echo Please wait about 15 seconds for the Oracle instance to initialize...
echo.
pause
echo.

REM leave Oracle running for next step

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:CREATE_DB
echo.
echo '=========================================
echo C. Create Benchmark Database
echo '=========================================
echo.
echo.

cd "C - Create Benchmark Database"

echo Create control, log and data file directories if needed
if not exist C:\Oracle\oradata\pcmag\nul mkdir C:\Oracle\oradata\pcmag
if not exist %ORACLE_LOG_DRIVE%\Oracle\nul mkdir %ORACLE_LOG_DRIVE%\Oracle
if not exist %ORACLE_LOG_DRIVE%\Oracle\Oradata\nul mkdir %ORACLE_LOG_DRIVE%\Oracle\Oradata
if not exist %ORACLE_LOG_DRIVE%\Oracle\Oradata\PCMag\nul mkdir %ORACLE_LOG_DRIVE%\Oracle\Oradata\PCMag
if not exist %ORACLE_DATA_DRIVE%\Oracle\nul mkdir %ORACLE_DATA_DRIVE%\Oracle
if not exist %ORACLE_DATA_DRIVE%\Oracle\Oradata\nul mkdir %ORACLE_DATA_DRIVE%\Oracle\Oradata
if not exist %ORACLE_DATA_DRIVE%\Oracle\Oradata\PCMag\nul mkdir %ORACLE_DATA_DRIVE%\Oracle\Oradata\PCMag
echo.

echo 1. Create database tablespaces
echo.
echo Create 'PCMAG' database (takes a while)
call ..\runsqlplus_nolog.bat c1-create_pcmag_db1
echo Create user tablespaces and catalogs (takes a while)
call ..\runsqlplus_nolog.bat c1-create_pcmag_db2
echo.

echo 2. Create 'PCMAG' database user, password is 'PCMAG'
call ..\runsqlplus_nolog.bat c2-create_pcmag_login

echo 3. Create database schema (tables and views)
call ..\runsqlplus_pcmag.bat c3-create_tables

echo 4. Create stored procedures for benchmark workload
echo.
echo Create stored procedures for OLTP write transactions
call ..\runsqlplus_pcmag.bat c4-create_oltp_write_package
echo.

echo 5. Save list of server settings
call ..\runsqlplus_pcmag.bat c5-show_parameters

echo.
echo Stop and restart database
echo.
oradim -shutdown -sid pcmag
oradim -startup -sid pcmag

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:LOAD_DB
echo.
echo '=========================================
echo D. Load Database
echo '=========================================
echo.
echo.

cd "D - Load Database"

echo Starting full data load
echo.
echo Current date and time:
date /t
time /t

echo 1. Bulk load data into tables
call d1-load_data.bat

echo.
echo Finished full data load
echo.
echo Current date and time:
date /t
time /t

echo.
echo Stop and restart database
echo.
oradim -shutdown -sid pcmag
oradim -startup -sid pcmag

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:INDEX_DB
echo.
echo '=========================================
echo E. Index Database
echo '=========================================
echo.
echo.

cd "E - Index Database"

echo Starting full indexing run
echo.
echo Current date and time:
date /t
time /t
echo.

echo 1. Build indices and add constraints
call ..\runsqlplus_pcmag.bat e1-create_indices

echo.
echo Finished full indexing run
echo.
echo Current date and time:
date /t
time /t

echo.
echo Stop and restart database
echo.
oradim -shutdown -sid pcmag
oradim -startup -sid pcmag

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:PRECHECK_DB
echo.
echo '=========================================
echo F. Run Pre-Benchmark Correctness Checks
echo '=========================================
echo.
echo.

cd "F - Run Pre-Benchmark Correctness Checks"

echo 1. Populate consistency tables
echo.
echo Populating consistency tables
call ..\runsqlplus_pcmag.bat f1-populate_consistency_tables

echo 2. Check consistency tables
echo.
echo Checking contents of consistency tables
call ..\runsqlplus_pcmag.bat f2-check_consistency_tables
fc /l f2-check_consistency_tables-output.txt f2-check_consistency_tables-output-MASTER.txt | find /v "SQL*Plus:"

echo 3. Check table sizes
echo.
echo Checking table sizes
call ..\runsqlplus_pcmag.bat f3-check_table_sizes
fc /l f3-check_table_sizes-output.txt f3-check_table_sizes-output-MASTER.txt | find /v "SQL*Plus:"

echo 4. Check results of OLTP read transactions
echo.
echo Checking OLTP read transactions
call ..\runsqlplus_pcmag.bat f4-check_oltp_read_workload
fc /l f4-check_oltp_read_workload-output.txt f4-check_oltp_read_workload-output-MASTER.txt | find /v "SQL*Plus:"

echo 5. Check results of OLTP write transactions
echo.
echo Checking and then undoing OLTP write transactions
call ..\runsqlplus_pcmag.bat f5-check_oltp_write_workload
fc /l f5-check_oltp_write_workload-output.txt f5-check_oltp_write_workload-output-MASTER.txt | find /v "SQL*Plus:"

echo 6. Check results of DSS transactions
echo.
echo Checking DSS transactions
call ..\runsqlplus_pcmag.bat f6-check_dss_workload
fc /l f6-check_dss_workload-output.txt f6-check_dss_workload-output-MASTER.txt | find /v "SQL*Plus:"

echo.
echo Stop and restart database
echo.
oradim -shutdown -sid pcmag
oradim -startup -sid pcmag

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:RUN_MIXES
echo.
echo '=========================================
echo G. Run Transaction Mixes
echo '=========================================
echo.
echo.

cd "G - Run Transaction Mixes"

echo Ready to run Benchmark Factory mixes.

cd %PCM_BENCHMARK_HOME_DIRECTORY%

goto END

rem =========================================
rem Error handling
rem =========================================

:FILES_MISSING_ERROR
echo.
echo The benchmark files are not located in %PCM_BENCHMARK_HOME_DIRECTORY%.
echo Please place them there and run this file again.
echo.

:END
echo.
echo Current date and time:
date /t
time /t
echo.
echo Benchmark setup completed.
