@echo off

echo.
echo Running PC Magazine database benchmark setup...
echo   Microsoft SQL Server 7.0 version
echo.
echo Current date and time:
date /t
time /t

:START
echo.
echo.
echo '===================================================
echo Set up file location variables and initial directory
echo '===================================================
echo.
echo.

echo 1. Set environment variables
set PCM_BENCHMARK_HOME_DRIVE=C:
set PCM_BENCHMARK_HOME_DIRECTORY=C:\MSSQLBench
if not exist "%PCM_BENCHMARK_HOME_DIRECTORY%\dbsetup_mssql.bat" goto FILES_MISSING_ERROR
%PCM_BENCHMARK_HOME_DRIVE%
cd %PCM_BENCHMARK_HOME_DIRECTORY%

rem Start point for script
goto CONFIG_DB

:CONFIG_DB
echo.
echo.
echo '=========================================
echo B. Configure Database Server
echo '=========================================
echo.
echo.

echo Press any key to configure the benchmark database. Make sure you have edited
echo this file to enter valid directory variables for your system first!
echo.
pause
echo.

cd "B - Configure Database Server"

echo Starting database (ignore error if it is already running)...
net start MSSQLServer

echo 1. Tune database server engine
call ..\runosql_sa.bat b1-server_tuning_70
echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer

echo 2. Move and resize tempdb
call ..\runosql_sa.bat b2-tempdb_setup_70_a
echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer
call ..\runosql_sa.bat b2-tempdb_setup_70_b

REM leave Microsoft SQL Server running for next step

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:CREATE_DB
echo.
echo '=========================================
echo C. Create Benchmark Database
echo '=========================================
echo.
echo.

cd "C - Create Benchmark Database"

echo 1. Create 'pcmag' database devices, create database, create 'pcmag' login
call ..\runosql_sa.bat c1-create_pcmag_db

echo 2. Create 'pcmag' database user, password is 'pcmag'
call ..\runosql_sa.bat c2-create_pcmag_login

echo 3. Create database schema (tables and views)
call ..\runosql_pcmag.bat c3-create_tables

echo 4. Create stored procedures for benchmark workload
echo.
echo Create stored procedures for OLTP read transactions
call ..\runosql_pcmag.bat c4-create_oltp_read_workload_sprocs
echo Create stored procedures for OLTP write transactions
call ..\runosql_pcmag.bat c4-create_oltp_write_workload_sprocs
echo Create stored procedures for DSS transactions
call ..\runosql_pcmag.bat c4-create_dss_workload_sprocs
echo.

echo 5. Save list of server settings
call ..\runosql_pcmag.bat c5-show_parameters

echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:LOAD_DB
echo.
echo '=========================================
echo D. Load Database
echo '=========================================
echo.
echo.

cd "D - Load Database"

echo Starting full data load
echo.
echo Current date and time:
date /t
time /t
echo.

echo 1. Bulk load data into tables
call ..\runosql_sa.bat d1-load_data

echo.
echo Finished full data load
echo.
echo Current date and time:
date /t
time /t

echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:INDEX_DB
echo.
echo '=========================================
echo E. Index Database
echo '=========================================
echo.
echo.

cd "E - Index Database"

echo Starting full indexing run
echo.
echo Current date and time:
date /t
time /t
echo.

echo 1. Build indices and add constraints
call ..\runosql_pcmag.bat e1-create_indicies

echo.
echo Finished full indexing run
echo.
echo Current date and time:
date /t
time /t

echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:PRECHECK_DB
echo.
echo '=========================================
echo F. Run Pre-Benchmark Correctness Checks
echo '=========================================
echo.
echo.

cd "F - Run Pre-Benchmark Correctness Checks"

echo 1. Populate consistency tables
echo.
echo Populating consistency tables
call ..\runosql_pcmag.bat f1-populate_consistency_tables
echo.

echo 2. Check consistency tables
echo.
echo Checking contents of consistency tables
call ..\runosql_pcmag.bat f2-check_consistency_tables
fc /l f2-check_consistency_tables-output.txt f2-check_consistency_tables-output-MASTER.txt

echo 3. Check table sizes
call ..\runosql_pcmag.bat f3-check_table_sizes
fc /l f3-check_table_sizes-output.txt f3-check_table_sizes-output-MASTER.txt

echo 4. Check results of OLTP read transactions
echo.
echo Checking OLTP read transactions
call ..\runosql_pcmag.bat f4-check_oltp_read_workload
fc /l f4-check_oltp_read_workload-output.txt f4-check_oltp_read_workload-output-MASTER.txt

echo 5. Check results of OLTP write transactions
echo.
echo Checking and then undoing OLTP write transactions
call ..\runosql_pcmag.bat f5-check_oltp_write_workload
fc /l f5-check_oltp_write_workload-output.txt f5-check_oltp_write_workload-output-MASTER.txt

echo 6. Check results of DSS transactions
echo.
echo Checking DSS transactions
call ..\runosql_pcmag.bat f6-check_dss_workload
fc /l f6-check_dss_workload-output.txt f6-check_dss_workload-output-MASTER.txt

echo.
echo Stop and restart database
echo.
net stop MSSQLServer
net start MSSQLServer

cd %PCM_BENCHMARK_HOME_DIRECTORY%

:RUN_MIXES
echo.
echo '=========================================
echo G. Run Transaction Mixes
echo '=========================================
echo.
echo.

cd "G - Run Transaction Mixes"

echo Ready to run Benchmark Factory mixes.

cd %PCM_BENCHMARK_HOME_DIRECTORY%

goto END

rem =========================================
rem Error handling
rem =========================================

:FILES_MISSING_ERROR
echo.
echo The benchmark files are not located in %PCM_BENCHMARK_HOME_DIRECTORY%.
echo Please place them there and run this file again.
echo.

:END
echo.
echo Current date and time:
date /t
time /t
echo.
echo Benchmark setup completed.
