@echo off

echo.
echo Checking correctness of PC Magazine benchmark database...
echo   Microsoft SQL Server 7.0 version
echo.
echo NOTE: Make sure you have undone the effects of any outstanding write procedures
echo before doing this (otherwise the check consistency tables will be wrong).
echo.
pause
echo.
echo Current date and time:
date /t
time /t

:START
echo.
echo.
echo '===================================================
echo Set up file location variables and initial directory
echo '===================================================
echo.
echo.

echo 1. Set environment variables
set PCM_BENCHMARK_HOME_DRIVE=C:
set PCM_BENCHMARK_HOME_DIRECTORY=C:\MSSQLBench

if not exist "%PCM_BENCHMARK_HOME_DIRECTORY%\dbcheck_all_mssql.bat" goto FILES_MISSING_ERROR

%PCM_BENCHMARK_HOME_DRIVE%
cd %PCM_BENCHMARK_HOME_DIRECTORY%

:CHECK_DB
echo.
echo.
echo '=========================================
echo H. Run Post-Benchmark Correctness Checks
echo '=========================================
echo.
echo.

cd "H - Run Post-Benchmark Correctness Checks"

echo 1. Check consistency tables
echo.
echo Checking contents of consistency tables
call ..\runosql_pcmag.bat h1-check_consistency_tables
fc /l h1-check_consistency_tables-output.txt h1-check_consistency_tables-output-MASTER.txt

echo 2. Check table sizes
echo.
echo Checking table sizes
call ..\runosql_pcmag.bat h2-check_table_sizes
fc /l h2-check_table_sizes-output.txt h2-check_table_sizes-output-MASTER.txt

echo 3. Check results of OLTP read transactions
echo.
echo Checking OLTP read transactions
call ..\runosql_pcmag.bat h3-check_oltp_read_workload
fc /l h3-check_oltp_read_workload-output.txt h3-check_oltp_read_workload-output-MASTER.txt

echo 4. Check results of OLTP write transactions
echo.
echo Running OLTP write transaction check procedures
call ..\runosql_pcmag.bat h4-check_oltp_write_workload
fc /l h4-check_oltp_write_workload-output.txt h4-check_oltp_write_workload-output-MASTER.txt

echo 5. Check results of DSS transactions
echo.
echo Checking DSS transactions
call ..\runosql_pcmag.bat h5-check_dss_workload
fc /l h5-check_dss_workload-output.txt h5-check_dss_workload-output-MASTER.txt

cd %PCM_BENCHMARK_HOME_DIRECTORY%

goto END

rem =========================================
rem Error handling
rem =========================================

:FILES_MISSING_ERROR
echo.
echo The benchmark files are not located in %PCM_BENCHMARK_HOME_DIRECTORY%.
echo Please place them there and run this file again.
echo.

:END
echo.
echo Current date and time:
date /t
time /t
echo.
echo Benchmark check completed.
