#include "color.h"

int triplet(int a,int b,int c) {
  return(((a&0xff)<<16)|((b&0xff)<<8)|(c&0xff));
}

int RGB2YCbCr(int v) {
  float y,cb,cr;

  y=0.257*(float)t0(v)+
    0.504*(float)t1(v)+
    0.098*(float)t2(v)+16.0;

  cb=-0.148*(float)t0(v)-
      0.291*(float)t1(v)+
      0.439*(float)t2(v)+
      128.0;

  cr=0.439*(float)t0(v)-
     0.368*(float)t1(v)-
     0.071*(float)t2(v)+
     128.0;

  return(triplet((int)y,(int)cb,(int)cr));
}

int YCbCr2RGB(int v) {
  float r,g,b;

  r=1.164*((float)t0(v)-16.0)+
    1.596*((float)t2(v)-128.0);

  g=1.164*((float)t0(v)-16.0)-
    0.813*((float)t2(v)-128.0)-
    0.392*((float)t1(v)-128.0);
  
  b=1.164*((float)t0(v)-16.0)+
    2.017*((float)t1(v)-128.0);

  if (r<0.0) r=0.0;
  if (g<0.0) g=0.0;
  if (b<0.0) b=0.0;
  if (r>255.0) r=255.0;
  if (g>255.0) g=255.0;
  if (b>255.0) b=255.0;

  return(triplet((int)r,(int)g,(int)b));
}


int RGB2HSV(int vi) {
  float r = (float) t0(vi), 
        g = (float) t1(vi), 
        b = (float) t2(vi), v, x, f; 
  float a[3];

  int i; 

  r/=255.0;
  g/=255.0;
  b/=255.0;

  // RGB are each on [0, 1]. S and V are returned on [0, 1] and H is 
  // returned on [0, 6]. 

  x = GMIN(r, g, b); 
  v = GMAX(r, g, b); 
  if (v == x) {
    a[0]=0.0;
    a[1]=0.0;
    a[2]=v;
  } else {
    f = (r == x) ? g - b : ((g == x) ? b - r : r - g); 
    i = (r == x) ? 3 : ((g == x) ? 5 : 1);
    a[0]=((float)i)-f/(v-x);
    a[1]=(v-x)/v;
    a[2]=v;
  }

  // (un)normalize

  a[0]*=255.0/6.0;
  a[1]*=255.0;
  a[2]*=255.0;
  
  return(triplet(ROUND(a[0]),ROUND(a[1]),ROUND(a[2])));
}

int HSV2RGB(int vi) {
  // H is given on [0, 6]. S and V are given on [0, 1]. 
  // RGB are each returned on [0, 1]. 
  float h = (float)t0(vi), 
        s = (float)t1(vi), 
        v = (float)t2(vi), m, n, f; 
  float a[3];
  int i; 

  h/=255.0/6.0;
  s/=255.0;
  v/=255.0;

  if (s==0.0) {
    a[0]=a[1]=a[2]=v;
  } else {
    i = (int) floor(h); 
    f = h - (float)i; 
    if(!(i & 1)) f = 1 - f; // if i is even 
    m = v * (1 - s); 
    n = v * (1 - s * f); 
    switch (i) { 
    case 6: 
    case 0: a[0]=v; a[1]=n; a[2]=m; break;
    case 1: a[0]=n; a[1]=v; a[2]=m; break;
    case 2: a[0]=m; a[1]=v; a[2]=n; break;
    case 3: a[0]=m; a[1]=n; a[2]=v; break;
    case 4: a[0]=n; a[1]=m; a[2]=v; break;
    case 5: a[0]=v; a[1]=m; a[2]=n; break;
    } 
  }

  // (un)normalize
  for(i=0;i<3;i++)
    a[i]*=255;

  return(triplet(ROUND(a[0]),ROUND(a[1]),ROUND(a[2])));
}

