#include "cimage.h"

CImage *CreateCImage(int ncols, int nrows)
{
  CImage *cimg=NULL;
  int i;

  cimg = (CImage *) calloc(1, sizeof(CImage));
  for (i=0; i < 3; i++) 
    cimg->C[i] = CreateImage(ncols,nrows);
  return(cimg);
}

void    DestroyCImage(CImage **cimg)
{
  CImage *tmp;
  int i;

  tmp = *cimg;
  if (tmp != NULL) {
    for (i=0; i < 3; i++) 
      DestroyImage(&(tmp->C[i]));
    free(tmp);
    *cimg = NULL;
  }
}

CImage *ReadCImage(char *filename)
{
  CImage *cimg=NULL;
  FILE *fp=NULL;
  char type[10];
  int  i,ncols,nrows,n;
  char z[256];

  fp = fopen(filename,"rb");
  if (fp == NULL){
    fprintf(stderr,"Cannot open %s\n",filename);
    exit(-1);
  }
  fscanf(fp,"%s\n",type);
  if((strcmp(type,"P6")==0)){
    NCFgets(z,255,fp);
    sscanf(z,"%d %d\n",&ncols,&nrows);
    n = ncols*nrows;
    NCFgets(z,255,fp);
    sscanf(z,"%d\n",&i);
    cimg = CreateCImage(ncols,nrows);
    for (i=0; i < n; i++){
      cimg->C[0]->val[i] = fgetc(fp);
      cimg->C[1]->val[i] = fgetc(fp);
      cimg->C[2]->val[i] = fgetc(fp);
    }
    fclose(fp);
  }else{
    fprintf(stderr,"Input image must be P6\n");
    exit(-1);
  }

  return(cimg);
}

void    WriteCImage(CImage *cimg, char *filename)
{
  FILE *fp;
  int i,n;

  fp = fopen(filename,"w");
  fprintf(fp,"P6\n");
  fprintf(fp,"%d %d\n",cimg->C[0]->ncols,cimg->C[0]->nrows);
  fprintf(fp,"255\n"); 
  n = cimg->C[0]->ncols*cimg->C[0]->nrows;
  for (i=0; i < n; i++) {
    fputc(cimg->C[0]->val[i],fp);
    fputc(cimg->C[1]->val[i],fp);
    fputc(cimg->C[2]->val[i],fp);
  }
  fclose(fp); 
}

CImage *CScale(CImage *cimg, float Sx, float Sy)
{
  CImage *scl=NULL;
  int i;

  scl = (CImage *) calloc(1,sizeof(CImage));
  if (scl == NULL){
    Error(MSG1,"CreateCImage");
  }
  for (i=0; i<3; i++)
    scl->C[i] = Scale(cimg->C[i], Sx, Sy);
  return (scl);
}


Image  *GetBand(CImage *cimg, char band)
{
  Image *img=CopyImage(cimg->C[(int)band]);

  return(img);
}

CImage *CImageRGBtoYCbCr(CImage *cimg)
{
  CImage *ncimg=NULL;
  int p,n,i;


  ncimg = CreateCImage(cimg->C[0]->ncols,cimg->C[0]->nrows);
  n    = ncimg->C[0]->ncols*ncimg->C[0]->nrows;

  for (p=0; p < n; p++){

    i = triplet(cimg->C[0]->val[p],cimg->C[1]->val[p],cimg->C[2]->val[p]);
    i = RGB2YCbCr(i);
    ncimg->C[0]->val[p]=t0(i);
    ncimg->C[1]->val[p]=t1(i);
    ncimg->C[2]->val[p]=t2(i);
  }

  return(ncimg);
}

CImage *CImageYCbCrtoRGB(CImage *cimg)
{
  CImage *ncimg=NULL;
  int p,n,i;


  ncimg = CreateCImage(cimg->C[0]->ncols,cimg->C[0]->nrows);
  n    = ncimg->C[0]->ncols*ncimg->C[0]->nrows;

  for (p=0; p < n; p++){

    i = triplet(cimg->C[0]->val[p],cimg->C[1]->val[p],cimg->C[2]->val[p]);
    i = YCbCr2RGB(i);
    ncimg->C[0]->val[p]=t0(i);
    ncimg->C[1]->val[p]=t1(i);
    ncimg->C[2]->val[p]=t2(i);
  }

  return(ncimg);
}

CImage *CImageRGBtoHSV(CImage *cimg)
{
  CImage *ncimg=NULL;
  int p,n,i;


  ncimg = CreateCImage(cimg->C[0]->ncols,cimg->C[0]->nrows);
  n    = ncimg->C[0]->ncols*ncimg->C[0]->nrows;

  for (p=0; p < n; p++){

    i = triplet(cimg->C[0]->val[p],cimg->C[1]->val[p],cimg->C[2]->val[p]);
    i = RGB2HSV(i);
    ncimg->C[0]->val[p]=t0(i);
    ncimg->C[1]->val[p]=t1(i);
    ncimg->C[2]->val[p]=t2(i);
  }

  return(ncimg);
}


CImage *CImageHSVtoRGB(CImage *cimg)
{
  CImage *ncimg=NULL;
  int p,n,i;


  ncimg = CreateCImage(cimg->C[0]->ncols,cimg->C[0]->nrows);
  n    = ncimg->C[0]->ncols*ncimg->C[0]->nrows;

  for (p=0; p < n; p++){

    i = triplet(cimg->C[0]->val[p],cimg->C[1]->val[p],cimg->C[2]->val[p]);
    i = HSV2RGB(i);
    ncimg->C[0]->val[p]=t0(i);
    ncimg->C[1]->val[p]=t1(i);
    ncimg->C[2]->val[p]=t2(i);
  }

  return(ncimg);
}
