#ifndef _IMAGE_H_
#define _IMAGE_H_

#include "common.h"

typedef struct _pixel {
  int x,y;
} Pixel;

typedef struct _image {
  int *val;
  int ncols,nrows;
  int *tbrow;
} Image;

Image  *CreateImage(int ncols,int nrows);
void    DestroyImage(Image **img);
Image  *ReadImage(char *filename);
void    WriteImage(Image *img, char *filename);
int     MinimumValue(Image *img);
int     MaximumValue(Image *img);
char    ValidPixel(Image *img, int x, int y);
Image  *Rotate(Image *img, float theta); 
Image  *Scale(Image *img, float Sx, float Sy); 
Image  *CopyImage(Image *img);

#endif





