#ifndef _CIMAGE_H_
#define _CIMAGE_H_

#include "image.h"
#include "color.h" 

typedef struct cimage {
  Image *C[3];
} CImage;

CImage *CreateCImage(int ncols, int nrows);
void    DestroyCImage(CImage **cimg);
CImage *ReadCImage(char *filename);
void    WriteCImage(CImage *cimg, char *filename);
CImage *CScale(CImage *cimg, float Sx, float Sy);
Image  *GetBand(CImage *cimg, char band);
CImage *CImageRGBtoYCbCr(CImage *cimg);
CImage *CImageYCbCrtoRGB(CImage *cimg);
CImage *CImageRGBtoHSV(CImage *cimg);
CImage *CImageHSVtoRGB(CImage *cimg);

#endif
