#include "colorspaces.h"

int main(int argc, char **argv)
{
  CImage  *cimg1,*cimg2;
  char filename[100];
  int p,n;

  /*--------------------------------------------------------*/

  if (argc != 2) {
    fprintf(stderr,"usage: colorspaces <basename>\n");
    fprintf(stderr,"Ler imagem basename.ppm e grava basename-out.ppm");
    exit(-1);
  }

  /* Ler imagem colorida */

  sprintf(filename,"%s.ppm",argv[1]); 
  cimg1   = ReadCImage(filename);

  /* converte de RGB para HSV */

  cimg2   = CImageRGBtoHSV(cimg1);
  
  /* reduz brilho pela metade */

  n = cimg2->C[2]->ncols*cimg2->C[2]->nrows;
  for (p=0; p < n; p++) 
    cimg2->C[2]->val[p]=cimg2->C[2]->val[p]/2.0;

  /* converte de volta para RGB */

  DestroyCImage(&cimg1);
  cimg1 = CImageHSVtoRGB(cimg2);

  /* grava imagem de saida com brilho constante */

  sprintf(filename,"%s-out.ppm",argv[1]);
  WriteCImage(cimg1,filename);

  /* libera espaco alocado */

  DestroyCImage(&cimg1);
  DestroyCImage(&cimg2);
 
  return(0);
}
